"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LayerSettings = LayerSettings;
var _react = _interopRequireDefault(require("react"));
var _lens_ui_telemetry = require("../../lens_ui_telemetry");
var _ignore_global_filter = require("../../shared_components/ignore_global_filter");
var _visualization_helpers = require("./visualization_helpers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/visualizations/xy/layer_settings.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function LayerSettings({
  state,
  setState,
  section,
  layerId
}) {
  if (section === 'appearance') {
    return null;
  }
  const layer = state.layers.find(l => l.layerId === layerId);
  if (!layer || !(0, _visualization_helpers.isAnnotationsLayer)(layer)) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_ignore_global_filter.IgnoreGlobalFilterRowControl, {
    checked: !layer.ignoreGlobalFilters,
    onChange: () => {
      const layerIndex = state.layers.findIndex(l => l === layer);
      const newLayer = {
        ...layer,
        ignoreGlobalFilters: !layer.ignoreGlobalFilters
      };
      const newLayers = [...state.layers];
      newLayers[layerIndex] = newLayer;
      (0, _lens_ui_telemetry.trackUiCounterEvents)(newLayer.ignoreGlobalFilters ? `ignore_global_filters` : `use_global_filters`);
      setState({
        ...state,
        layers: newLayers
      });
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 5
    }
  });
}