"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AppearancePopover = AppearancePopover;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _visualizationUtils = require("@kbn/visualization-utils");
var _visualizationUiComponents = require("@kbn/visualization-ui-components");
var _shared_components = require("../../../shared_components");
var _constants = require("../constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/visualizations/metric/toolbar/appearance_popover.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/** Get default layout config based on primary metric position */
const getDefaultLayoutConfig = (primaryMetricPosition, {
  hasMetricIcon,
  hasSecondaryMetric
}) => {
  let config = {
    ..._constants.METRIC_LAYOUT_BY_POSITION[primaryMetricPosition]
  };
  if (!hasMetricIcon) {
    const {
      iconAlign,
      ...rest
    } = config;
    config = rest;
  }
  if (!hasSecondaryMetric) {
    const {
      secondaryAlign,
      ...rest
    } = config;
    config = rest;
  }
  return config;
};
function AppearancePopover({
  state,
  setState,
  groupPosition
}) {
  var _state$primaryPositio, _state$primaryAlign, _state$valueFontMode, _state$titlesTextAlig, _state$titleWeight, _state$secondaryAlign, _state$iconAlign;
  const hasSecondaryMetric = !!state.secondaryMetricAccessor;
  const hasMetricIcon = (0, _visualizationUiComponents.hasIcon)(state.icon);
  const disabledStates = {
    subtitle: !!state.breakdownByAccessor,
    secondaryAlign: !hasSecondaryMetric,
    iconAlign: !hasMetricIcon
  };
  return /*#__PURE__*/_react.default.createElement(_shared_components.ToolbarPopover, {
    title: _i18n.i18n.translate('xpack.lens.metric.appearancePopover.title', {
      defaultMessage: 'Appearance'
    }),
    type: "visualOptions",
    groupPosition: groupPosition,
    buttonDataTestSubj: "lnsTextOptionsButton",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(AppearanceOptionGroup, {
    title: _i18n.i18n.translate('xpack.lens.metric.appearancePopover.primaryMetric.title', {
      defaultMessage: 'Primary metric'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(AppearanceOption, {
    label: _i18n.i18n.translate('xpack.lens.metric.appearancePopover.position', {
      defaultMessage: 'Position'
    }),
    value: (_state$primaryPositio = state.primaryPosition) !== null && _state$primaryPositio !== void 0 ? _state$primaryPositio : _constants.metricStateDefaults.primaryPosition,
    options: primaryMetricPositionOptions,
    onChange: id => {
      setState({
        ...state,
        primaryPosition: id,
        ...getDefaultLayoutConfig(id, {
          hasMetricIcon,
          hasSecondaryMetric
        })
      });
    },
    dataTestSubj: "lens-metric-appearance-primary-metric-position-btn",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(AppearanceOption, {
    label: _i18n.i18n.translate('xpack.lens.metric.appearancePopover.alignment', {
      defaultMessage: 'Alignment'
    }),
    value: (_state$primaryAlign = state.primaryAlign) !== null && _state$primaryAlign !== void 0 ? _state$primaryAlign : _constants.metricStateDefaults.primaryAlign,
    options: alignmentOptions,
    onChange: id => {
      setState({
        ...state,
        primaryAlign: id
      });
    },
    isIconOnly: true,
    dataTestSubj: "lens-metric-appearance-primary-metric-alignment-btn",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(AppearanceOption, {
    label: _i18n.i18n.translate('xpack.lens.metric.appearancePopover.fontSize', {
      defaultMessage: 'Font size'
    }),
    value: (_state$valueFontMode = state.valueFontMode) !== null && _state$valueFontMode !== void 0 ? _state$valueFontMode : _constants.metricStateDefaults.valueFontMode,
    options: fontSizeOptions,
    onChange: id => {
      setState({
        ...state,
        valueFontMode: id
      });
    },
    dataTestSubj: "lens-metric-appearance-primary-metric-font-size-btn",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(AppearanceOptionGroup, {
    title: _i18n.i18n.translate('xpack.lens.metric.appearancePopover.titleAndSubtitle.title', {
      defaultMessage: 'Title and subtitle'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(SubtitleOption, {
    value: state.subtitle,
    onChange: subtitle => {
      setState({
        ...state,
        subtitle
      });
    },
    isDisabled: disabledStates.subtitle,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(AppearanceOption, {
    label: _i18n.i18n.translate('xpack.lens.metric.appearancePopover.alignment', {
      defaultMessage: 'Alignment'
    }),
    value: (_state$titlesTextAlig = state.titlesTextAlign) !== null && _state$titlesTextAlig !== void 0 ? _state$titlesTextAlig : _constants.metricStateDefaults.titlesTextAlign,
    options: alignmentOptions,
    onChange: id => {
      setState({
        ...state,
        titlesTextAlign: id
      });
    },
    isIconOnly: true,
    dataTestSubj: "lens-metric-appearance-title-and-subtitle-alignment-btn",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(AppearanceOption, {
    label: _i18n.i18n.translate('xpack.lens.metric.appearancePopover.fontWeight', {
      defaultMessage: 'Font weight'
    }),
    value: (_state$titleWeight = state.titleWeight) !== null && _state$titleWeight !== void 0 ? _state$titleWeight : _constants.metricStateDefaults.titleWeight,
    options: fontWeightOptions,
    onChange: id => {
      setState({
        ...state,
        titleWeight: id
      });
    },
    dataTestSubj: "lens-metric-appearance-title-and-subtitle-font-weight-btn",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 174,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(AppearanceOptionGroup, {
    title: _i18n.i18n.translate('xpack.lens.metric.appearancePopover.secondaryMetric.title', {
      defaultMessage: 'Secondary metric'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(AppearanceOption, {
    label: _i18n.i18n.translate('xpack.lens.metric.appearancePopover.alignment', {
      defaultMessage: 'Alignment'
    }),
    value: (_state$secondaryAlign = state.secondaryAlign) !== null && _state$secondaryAlign !== void 0 ? _state$secondaryAlign : _constants.metricStateDefaults.secondaryAlign,
    options: alignmentOptions,
    onChange: id => {
      setState({
        ...state,
        secondaryAlign: id
      });
    },
    isDisabled: disabledStates.secondaryAlign,
    isIconOnly: true,
    dataTestSubj: "lens-metric-appearance-secondary-metric-alignment-btn",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 180,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 197,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(AppearanceOptionGroup, {
    title: _i18n.i18n.translate('xpack.lens.metric.appearancePopover.other.title', {
      defaultMessage: 'Other'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 198,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(AppearanceOption, {
    label: _i18n.i18n.translate('xpack.lens.metric.appearancePopover.iconPosition', {
      defaultMessage: 'Icon position'
    }),
    value: (_state$iconAlign = state.iconAlign) !== null && _state$iconAlign !== void 0 ? _state$iconAlign : _constants.legacyMetricStateDefaults.iconAlign,
    options: iconPositionOptions,
    onChange: id => {
      setState({
        ...state,
        iconAlign: id
      });
    },
    isDisabled: disabledStates.iconAlign,
    dataTestSubj: "lens-metric-appearance-other-icon-position-btn",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 203,
      columnNumber: 9
    }
  })));
}
function AppearanceOptionGroup({
  title,
  children
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 225,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 226,
      columnNumber: 7
    }
  }, title), children);
}
function SubtitleOption({
  value = '',
  onChange,
  isDisabled
}) {
  const {
    inputValue,
    handleInputChange
  } = (0, _visualizationUtils.useDebouncedValue)({
    onChange,
    value
  }, {
    allowFalsyValue: true
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.lens.metric.appearancePopover.subtitle', {
      defaultMessage: 'Subtitle'
    }),
    fullWidth: true,
    display: "columnCompressed",
    isDisabled: isDisabled,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 247,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    compressed: true,
    "data-test-subj": "lens-metric-appearance-subtitle-field",
    value: inputValue,
    onChange: ({
      target: {
        value: newValue
      }
    }) => handleInputChange(newValue),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 255,
      columnNumber: 7
    }
  }));
}
function AppearanceOption({
  label,
  value,
  options,
  onChange,
  isDisabled = false,
  isIconOnly = false,
  dataTestSubj
}) {
  const onChangeOption = clickedOptionId => {
    // Prevent onChange method call if the option clicked is selected
    if (value !== clickedOptionId) {
      onChange(clickedOptionId);
    }
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed",
    label: label,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 292,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    isFullWidth: true,
    legend: label,
    "data-test-subj": dataTestSubj,
    buttonSize: "compressed",
    options: options
    // Don't show selected option if the button group is disabled
    ,
    idSelected: isDisabled ? '' : value,
    isDisabled: isDisabled,
    onChange: onChangeOption,
    isIconOnly: isIconOnly,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 293,
      columnNumber: 7
    }
  }));
}
const alignmentOptions = [{
  id: 'left',
  label: _i18n.i18n.translate('xpack.lens.shared.left', {
    defaultMessage: 'Left'
  }),
  iconType: 'editorAlignLeft'
}, {
  id: 'center',
  label: _i18n.i18n.translate('xpack.lens.shared.center', {
    defaultMessage: 'Center'
  }),
  iconType: 'editorAlignCenter'
}, {
  id: 'right',
  label: _i18n.i18n.translate('xpack.lens.shared.right', {
    defaultMessage: 'Right'
  }),
  iconType: 'editorAlignRight'
}];
const iconPositionOptions = [{
  id: 'left',
  label: _i18n.i18n.translate('xpack.lens.shared.left', {
    defaultMessage: 'Left'
  })
}, {
  id: 'right',
  label: _i18n.i18n.translate('xpack.lens.shared.right', {
    defaultMessage: 'Right'
  })
}];
const fontWeightOptions = [{
  id: 'normal',
  label: _i18n.i18n.translate('xpack.lens.metric.appearancePopover.regular', {
    defaultMessage: 'Regular'
  })
}, {
  id: 'bold',
  label: _i18n.i18n.translate('xpack.lens.metric.appearancePopover.bold', {
    defaultMessage: 'Bold'
  })
}];
const fontSizeOptions = [{
  id: 'default',
  label: _i18n.i18n.translate('xpack.lens.metric.appearancePopover.default', {
    defaultMessage: 'Default'
  })
}, {
  id: 'fit',
  label: _i18n.i18n.translate('xpack.lens.metric.appearancePopover.fit', {
    defaultMessage: 'Fit'
  })
}];
const primaryMetricPositionOptions = [{
  id: 'top',
  label: _i18n.i18n.translate('xpack.lens.metric.appearancePopover.top', {
    defaultMessage: 'Top'
  })
}, {
  id: 'bottom',
  label: _i18n.i18n.translate('xpack.lens.metric.appearancePopover.bottom', {
    defaultMessage: 'Bottom'
  })
}];