"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DEFAULT_TEXT_ALIGNMENT = exports.AlignOptions = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/visualizations/legacy_metric/metric_config_panel/align_options.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const DEFAULT_TEXT_ALIGNMENT = exports.DEFAULT_TEXT_ALIGNMENT = 'left';
const alignButtonIcons = [{
  id: `left`,
  label: _i18n.i18n.translate('xpack.lens.legacyMetric.alignLabel.left', {
    defaultMessage: 'Align left'
  }),
  iconType: 'editorAlignLeft'
}, {
  id: `center`,
  label: _i18n.i18n.translate('xpack.lens.legacyMetric.alignLabel.center', {
    defaultMessage: 'Align center'
  }),
  iconType: 'editorAlignCenter'
}, {
  id: `right`,
  label: _i18n.i18n.translate('xpack.lens.legacyMetric.alignLabel.right', {
    defaultMessage: 'Align right'
  }),
  iconType: 'editorAlignRight'
}];
const AlignOptions = ({
  state,
  setState
}) => {
  var _state$textAlign;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    legend: _i18n.i18n.translate('xpack.lens.legacyMetric.titleAlignLabel', {
      defaultMessage: 'Align'
    }),
    options: alignButtonIcons,
    idSelected: (_state$textAlign = state.textAlign) !== null && _state$textAlign !== void 0 ? _state$textAlign : DEFAULT_TEXT_ALIGNMENT,
    onChange: id => {
      setState({
        ...state,
        textAlign: id
      });
    },
    isIconOnly: true,
    buttonSize: "compressed",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 5
    }
  });
};
exports.AlignOptions = AlignOptions;