"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DEFAULT_FLOATING_COLUMNS = exports.ColumnsNumberSetting = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _visualizationUtils = require("@kbn/visualization-utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/shared_components/legend/layout/columns_number_setting.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const DEFAULT_FLOATING_COLUMNS = exports.DEFAULT_FLOATING_COLUMNS = 1;
const ColumnsNumberSetting = ({
  floatingColumns,
  onFloatingColumnsChange = () => {},
  isHidden
}) => {
  const {
    inputValue,
    handleInputChange
  } = (0, _visualizationUtils.useDebouncedValue)({
    value: floatingColumns !== null && floatingColumns !== void 0 ? floatingColumns : DEFAULT_FLOATING_COLUMNS,
    onChange: onFloatingColumnsChange
  });
  if (isHidden) return null;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.lens.shared.legendInsideColumnsLabel', {
      defaultMessage: 'Number of columns'
    }),
    fullWidth: true,
    display: "columnCompressed",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    "data-test-subj": "lens-legend-location-columns-input",
    value: inputValue,
    min: 1,
    max: 5,
    compressed: true,
    onChange: e => {
      handleInputChange(Number(e.target.value));
    },
    step: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 7
    }
  }));
};
exports.ColumnsNumberSetting = ColumnsNumberSetting;