"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ToolbarTitleSettings = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _visualizationUtils = require("@kbn/visualization-utils");
var _ = require("../..");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/shared_components/axis/title/toolbar_title_settings.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const axisStrings = {
  header: _i18n.i18n.translate('xpack.lens.label.shared.axisHeader', {
    defaultMessage: 'Axis title'
  }),
  label: _i18n.i18n.translate('xpack.lens.shared.axisNameLabel', {
    defaultMessage: 'Axis title'
  }),
  getDataTestSubj: axis => `lns${axis}AxisTitle`
};
const ToolbarTitleSettings = ({
  settingId,
  title,
  updateTitleState,
  isTitleVisible,
  strings = axisStrings,
  placeholder = _i18n.i18n.translate('xpack.lens.shared.overwriteAxisTitle', {
    defaultMessage: 'Overwrite axis title'
  })
}) => {
  const axisState = (0, _react.useMemo)(() => ({
    title,
    visibility: !title && isTitleVisible ? 'auto' : isTitleVisible ? 'custom' : 'none'
  }), [title, isTitleVisible]);
  const onTitleChange = (0, _react.useCallback)(({
    title: t,
    visibility
  }) => updateTitleState({
    title: t,
    visible: visibility !== 'none'
  }, settingId), [settingId, updateTitleState]);
  const {
    inputValue: localState,
    handleInputChange: onLocalTitleChange
  } = (0, _visualizationUtils.useDebouncedValue)({
    value: axisState,
    onChange: onTitleChange
  }, {
    allowFalsyValue: true
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed",
    label: strings.header,
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_.VisLabel, {
    header: strings.label,
    dataTestSubj: strings.getDataTestSubj(settingId),
    label: localState.title,
    mode: localState.visibility,
    placeholder: placeholder,
    hasAutoOption: true,
    handleChange: ({
      mode,
      label
    }) => {
      onLocalTitleChange({
        title: label,
        visibility: mode
      });
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 7
    }
  }));
};
exports.ToolbarTitleSettings = ToolbarTitleSettings;