"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChartSwitchPopover = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _visualizationUiComponents = require("@kbn/visualization-ui-components");
var _react2 = require("@emotion/react");
var _state_management = require("../../../../state_management");
var _chart_switch = require("./chart_switch");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/editor_frame_service/editor_frame/config_panel/chart_switch/chart_switch_popover.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ChartSwitchPopover = exports.ChartSwitchPopover = /*#__PURE__*/(0, _react.memo)(function ChartSwitchPopover(props) {
  var _props$visualizationM;
  const [flyoutOpen, setFlyoutOpen] = (0, _react.useState)(false);
  const visualization = (0, _state_management.useLensSelector)(_state_management.selectVisualization);
  const {
    icon,
    label
  } = visualization.activeId && ((_props$visualizationM = props.visualizationMap[visualization.activeId]) === null || _props$visualizationM === void 0 ? void 0 : _props$visualizationM.getDescription(visualization.state, props.layerId)) || {
    label: _i18n.i18n.translate('xpack.lens.configPanel.selectVisualization', {
      defaultMessage: 'Select a visualization'
    }),
    icon: undefined
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    css: (0, _react2.css)`
        display: flex;
      `,
    id: "lnsChartSwitchPopover",
    ownFocus: true,
    initialFocus: ".lnsChartSwitch__popoverPanel",
    panelClassName: "lnsChartSwitch__popoverPanel",
    panelPaddingSize: "none",
    repositionOnScroll: true,
    button: /*#__PURE__*/_react.default.createElement(_visualizationUiComponents.ChartSwitchTrigger, {
      icon: icon,
      label: label,
      dataTestSubj: "lnsChartSwitchPopover",
      onClick: () => setFlyoutOpen(!flyoutOpen),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 46,
        columnNumber: 9
      }
    }),
    isOpen: flyoutOpen,
    closePopover: () => setFlyoutOpen(false),
    anchorPosition: "downLeft",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 5
    }
  }, flyoutOpen ? /*#__PURE__*/_react.default.createElement(_chart_switch.ChartSwitch, (0, _extends2.default)({}, props, {
    onChartSelect: () => setFlyoutOpen(false),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 21
    }
  })) : null);
});