"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sumOperation = exports.standardDeviationOperation = exports.minOperation = exports.medianOperation = exports.maxOperation = exports.averageOperation = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/expressions-plugin/public");
var _lensFormulaDocs = require("@kbn/lens-formula-docs");
var _esqlUtils = require("@kbn/esql-utils");
var _helpers = require("./helpers");
var _time_scale_utils = require("../time_scale_utils");
var _layer_helpers = require("../layer_helpers");
var _reduced_time_range_utils = require("../../reduced_time_range_utils");
var _get_group_by_key = require("./get_group_by_key");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/datasources/form_based/operations/definitions/metrics.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const typeToFn = {
  min: 'aggMin',
  max: 'aggMax',
  average: 'aggAvg',
  sum: 'aggSum',
  median: 'aggMedian',
  standard_deviation: 'aggStdDeviation'
};
const typeToESQLFn = {
  min: 'MIN',
  max: 'MAX',
  average: 'AVG',
  sum: 'SUM',
  median: 'MEDIAN',
  standard_deviation: 'MEDIAN_ABSOLUTE_DEVIATION'
};
const supportedTypes = ['number', 'histogram'];
function isTimeSeriesCompatible(type, timeSeriesMetric) {
  return timeSeriesMetric !== 'counter' || ['min', 'max'].includes(type);
}
function buildMetricOperation({
  type,
  displayName,
  description,
  ofName,
  priority,
  optionalTimeScaling,
  supportsDate,
  hideZeroOption,
  aggConfigParams,
  quickFunctionDocumentation,
  unsupportedSettings
}) {
  const labelLookup = (name, column) => {
    const label = ofName(name);
    return (0, _time_scale_utils.adjustTimeScaleLabelSuffix)(label, undefined, optionalTimeScaling ? column === null || column === void 0 ? void 0 : column.timeScale : undefined, undefined, column === null || column === void 0 ? void 0 : column.timeShift, undefined, column === null || column === void 0 ? void 0 : column.reducedTimeRange);
  };
  return {
    type,
    allowAsReference: true,
    priority,
    displayName,
    description,
    input: 'field',
    timeScalingMode: optionalTimeScaling ? 'optional' : undefined,
    getUnsupportedSettings: () => unsupportedSettings,
    getPossibleOperationForField: ({
      aggregationRestrictions,
      aggregatable,
      type: fieldType,
      timeSeriesMetric
    }) => {
      if ((supportedTypes.includes(fieldType) || supportsDate && fieldType === 'date') && aggregatable && isTimeSeriesCompatible(type, timeSeriesMetric) && (!aggregationRestrictions || aggregationRestrictions[type])) {
        return {
          dataType: fieldType === 'date' ? 'date' : 'number',
          isBucketed: false,
          scale: 'ratio'
        };
      }
    },
    isTransferable: (column, newIndexPattern) => {
      const newField = newIndexPattern.getFieldByName(column.sourceField);
      return Boolean(newField && supportedTypes.includes(newField.type) && newField.aggregatable && (!newField.aggregationRestrictions || newField.aggregationRestrictions[type]));
    },
    getDefaultLabel: (column, columns, indexPattern) => labelLookup((0, _helpers.getSafeName)(column.sourceField, indexPattern), column),
    buildColumn: ({
      field,
      previousColumn
    }, columnParams) => {
      var _previousColumn$param;
      return {
        label: labelLookup(field.displayName, previousColumn),
        dataType: supportsDate && field.type === 'date' ? 'date' : 'number',
        operationType: type,
        sourceField: field.name,
        isBucketed: false,
        timeScale: optionalTimeScaling ? previousColumn === null || previousColumn === void 0 ? void 0 : previousColumn.timeScale : undefined,
        filter: (0, _helpers.getFilter)(previousColumn, columnParams),
        timeShift: (columnParams === null || columnParams === void 0 ? void 0 : columnParams.shift) || (previousColumn === null || previousColumn === void 0 ? void 0 : previousColumn.timeShift),
        reducedTimeRange: (columnParams === null || columnParams === void 0 ? void 0 : columnParams.reducedTimeRange) || (previousColumn === null || previousColumn === void 0 ? void 0 : previousColumn.reducedTimeRange),
        params: {
          ...(0, _helpers.getFormatFromPreviousColumn)(previousColumn),
          emptyAsNull: hideZeroOption && previousColumn && (0, _helpers.isColumnOfType)(type, previousColumn) ? (_previousColumn$param = previousColumn.params) === null || _previousColumn$param === void 0 ? void 0 : _previousColumn$param.emptyAsNull : !(columnParams !== null && columnParams !== void 0 && columnParams.usedInMath)
        }
      };
    },
    onFieldChange: (oldColumn, field) => {
      return {
        ...oldColumn,
        label: labelLookup(field.displayName, oldColumn),
        dataType: field.type,
        sourceField: field.name
      };
    },
    getAdvancedOptions: ({
      layer,
      columnId,
      currentColumn,
      paramEditorUpdater,
      euiTheme
    }) => {
      var _currentColumn$params;
      if (!hideZeroOption) return [];
      return [{
        dataTestSubj: 'hide-zero-values',
        inlineElement: /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
          label: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
            size: "xs",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 188,
              columnNumber: 17
            }
          }, _i18n.i18n.translate('xpack.lens.indexPattern.hideZero', {
            defaultMessage: 'Hide zero values'
          })),
          labelProps: {
            style: {
              fontWeight: euiTheme.font.weight.medium
            }
          },
          checked: Boolean((_currentColumn$params = currentColumn.params) === null || _currentColumn$params === void 0 ? void 0 : _currentColumn$params.emptyAsNull),
          onChange: () => {
            var _currentColumn$params2;
            paramEditorUpdater((0, _layer_helpers.updateColumnParam)({
              layer,
              columnId,
              paramName: 'emptyAsNull',
              value: !((_currentColumn$params2 = currentColumn.params) !== null && _currentColumn$params2 !== void 0 && _currentColumn$params2.emptyAsNull)
            }));
          },
          compressed: true,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 186,
            columnNumber: 13
          }
        })
      }];
    },
    toESQL: (column, columnId, _indexPattern, layer) => {
      if (column.timeShift) return;
      if (!typeToESQLFn[type]) return;
      return `${typeToESQLFn[type]}(${(0, _esqlUtils.sanitazeESQLInput)(column.sourceField)})`;
    },
    toEsAggsFn: (column, columnId, _indexPattern) => {
      var _column$params;
      return (0, _public.buildExpressionFunction)(typeToFn[type], {
        id: columnId,
        enabled: true,
        schema: 'metric',
        field: column.sourceField,
        // time shift is added to wrapping aggFilteredMetric if filter is set
        timeShift: column.filter ? undefined : column.timeShift,
        emptyAsNull: hideZeroOption ? (_column$params = column.params) === null || _column$params === void 0 ? void 0 : _column$params.emptyAsNull : undefined,
        ...aggConfigParams
      }).toAst();
    },
    getGroupByKey: agg => {
      return (0, _get_group_by_key.getGroupByKey)(agg, [typeToFn[type]], [{
        name: 'field'
      }, {
        name: 'emptyAsNull',
        transformer: val => String(Boolean(val))
      }]);
    },
    getErrorMessage: (layer, columnId, indexPattern) => [...(0, _helpers.getInvalidFieldMessage)(layer, columnId, indexPattern), ...(0, _reduced_time_range_utils.getColumnReducedTimeRangeError)(layer, columnId, indexPattern)],
    filterable: true,
    canReduceTimeRange: true,
    quickFunctionDocumentation,
    shiftable: true
  };
}
const minOperation = exports.minOperation = buildMetricOperation({
  type: _lensFormulaDocs.MIN_ID,
  displayName: _lensFormulaDocs.MIN_NAME,
  ofName: name => _i18n.i18n.translate('xpack.lens.indexPattern.minOf', {
    defaultMessage: 'Minimum of {name}',
    values: {
      name
    }
  }),
  description: _i18n.i18n.translate('xpack.lens.indexPattern.min.description', {
    defaultMessage: 'A single-value metrics aggregation that returns the minimum value among the numeric values extracted from the aggregated documents.'
  }),
  quickFunctionDocumentation: _i18n.i18n.translate('xpack.lens.indexPattern.min.quickFunctionDescription', {
    defaultMessage: 'The minimum value of a number field.'
  }),
  supportsDate: true,
  unsupportedSettings: {
    sampling: false
  }
});
const maxOperation = exports.maxOperation = buildMetricOperation({
  type: _lensFormulaDocs.MAX_ID,
  displayName: _lensFormulaDocs.MAX_NAME,
  ofName: name => _i18n.i18n.translate('xpack.lens.indexPattern.maxOf', {
    defaultMessage: 'Maximum of {name}',
    values: {
      name
    }
  }),
  description: _i18n.i18n.translate('xpack.lens.indexPattern.max.description', {
    defaultMessage: 'A single-value metrics aggregation that returns the maximum value among the numeric values extracted from the aggregated documents.'
  }),
  quickFunctionDocumentation: _i18n.i18n.translate('xpack.lens.indexPattern.max.quickFunctionDescription', {
    defaultMessage: 'The maximum value of a number field.'
  }),
  supportsDate: true,
  unsupportedSettings: {
    sampling: false
  }
});
const averageOperation = exports.averageOperation = buildMetricOperation({
  type: _lensFormulaDocs.AVG_ID,
  priority: 2,
  displayName: _lensFormulaDocs.AVG_NAME,
  ofName: name => _i18n.i18n.translate('xpack.lens.indexPattern.avgOf', {
    defaultMessage: 'Average of {name}',
    values: {
      name
    }
  }),
  description: _i18n.i18n.translate('xpack.lens.indexPattern.avg.description', {
    defaultMessage: 'A single-value metric aggregation that computes the average of numeric values that are extracted from the aggregated documents'
  }),
  quickFunctionDocumentation: _i18n.i18n.translate('xpack.lens.indexPattern.avg.quickFunctionDescription', {
    defaultMessage: 'The mean value of a set of number fields.'
  })
});
const standardDeviationOperation = exports.standardDeviationOperation = buildMetricOperation({
  type: _lensFormulaDocs.STD_DEVIATION_ID,
  displayName: _lensFormulaDocs.STD_DEVIATION_NAME,
  ofName: name => _i18n.i18n.translate('xpack.lens.indexPattern.standardDeviationOf', {
    defaultMessage: 'Standard deviation of {name}',
    values: {
      name
    }
  }),
  description: _i18n.i18n.translate('xpack.lens.indexPattern.standardDeviation.description', {
    defaultMessage: 'A single-value metric aggregation that computes the standard deviation of numeric values that are extracted from the aggregated documents'
  }),
  aggConfigParams: {
    showBounds: false
  },
  quickFunctionDocumentation: _i18n.i18n.translate('xpack.lens.indexPattern.standardDeviation.quickFunctionDescription', {
    defaultMessage: 'The standard deviation of the values of a number field which is the amount of variation of the fields values.'
  })
});
const sumOperation = exports.sumOperation = buildMetricOperation({
  type: _lensFormulaDocs.SUM_ID,
  priority: 1,
  displayName: _lensFormulaDocs.SUM_NAME,
  ofName: name => _i18n.i18n.translate('xpack.lens.indexPattern.sumOf', {
    defaultMessage: 'Sum of {name}',
    values: {
      name
    }
  }),
  optionalTimeScaling: true,
  description: _i18n.i18n.translate('xpack.lens.indexPattern.sum.description', {
    defaultMessage: 'A single-value metrics aggregation that sums up numeric values that are extracted from the aggregated documents.'
  }),
  hideZeroOption: true,
  quickFunctionDocumentation: _i18n.i18n.translate('xpack.lens.indexPattern.sum.quickFunctionDescription', {
    defaultMessage: 'The total amount of the values of a number field.'
  })
});
const medianOperation = exports.medianOperation = buildMetricOperation({
  type: _lensFormulaDocs.MEDIAN_ID,
  priority: 3,
  displayName: _lensFormulaDocs.MEDIAN_NAME,
  ofName: name => _i18n.i18n.translate('xpack.lens.indexPattern.medianOf', {
    defaultMessage: 'Median of {name}',
    values: {
      name
    }
  }),
  description: _i18n.i18n.translate('xpack.lens.indexPattern.median.description', {
    defaultMessage: 'A single-value metrics aggregation that computes the median value that are extracted from the aggregated documents.'
  }),
  quickFunctionDocumentation: _i18n.i18n.translate('xpack.lens.indexPattern.median.quickFunctionDescription', {
    defaultMessage: 'The median value of a number field.'
  })
});