"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldSelect = FieldSelect;
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _use_existing_fields = require("@kbn/unified-field-list/src/hooks/use_existing_fields");
var _visualizationUiComponents = require("@kbn/visualization-ui-components");
var _fieldUtils = require("@kbn/field-utils");
var _shared_components = require("../../../shared_components");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/datasources/form_based/dimension_panel/field_select.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function FieldSelect({
  currentIndexPattern,
  incompleteOperation,
  selectedOperationType,
  selectedField,
  operationByField,
  onChoose,
  onDeleteColumn,
  fieldIsInvalid,
  markAllFieldsCompatible,
  ['data-test-subj']: dataTestSub,
  showTimeSeriesDimensions,
  ['aria-describedby']: ariaDescribedby
}) {
  var _ref, _currentIndexPattern$7;
  const {
    hasFieldData
  } = (0, _use_existing_fields.useExistingFieldsReader)();
  const memoizedFieldOptions = (0, _react.useMemo)(() => {
    const fields = [...operationByField.keys()].sort();
    const currentOperationType = incompleteOperation !== null && incompleteOperation !== void 0 ? incompleteOperation : selectedOperationType;
    function isCompatibleWithCurrentOperation(fieldName) {
      return !currentOperationType || operationByField.get(fieldName).has(currentOperationType);
    }
    const [specialFields, normalFields] = (0, _lodash.partition)(fields, field => {
      var _currentIndexPattern$;
      return ((_currentIndexPattern$ = currentIndexPattern.getFieldByName(field)) === null || _currentIndexPattern$ === void 0 ? void 0 : _currentIndexPattern$.type) === 'document';
    });
    function containsData(fieldName) {
      return (0, _shared_components.fieldContainsData)(fieldName, currentIndexPattern, hasFieldData);
    }
    function fieldNamesToOptions(items) {
      return items.filter(field => {
        var _currentIndexPattern$2;
        return (_currentIndexPattern$2 = currentIndexPattern.getFieldByName(field)) === null || _currentIndexPattern$2 === void 0 ? void 0 : _currentIndexPattern$2.displayName;
      }).map(field => {
        var _currentIndexPattern$3, _currentIndexPattern$4;
        const compatible = markAllFieldsCompatible || isCompatibleWithCurrentOperation(field) ? 1 : 0;
        const exists = containsData(field);
        const fieldInstance = currentIndexPattern.getFieldByName(field);
        return {
          label: (_currentIndexPattern$3 = (_currentIndexPattern$4 = currentIndexPattern.getFieldByName(field)) === null || _currentIndexPattern$4 === void 0 ? void 0 : _currentIndexPattern$4.displayName) !== null && _currentIndexPattern$3 !== void 0 ? _currentIndexPattern$3 : field,
          value: {
            type: 'field',
            field,
            dataType: fieldInstance ? (0, _fieldUtils.getFieldIconType)(fieldInstance) : undefined,
            // Use the operation directly, or choose the first compatible operation.
            // All fields are guaranteed to have at least one operation because they
            // won't appear in the list otherwise
            operationType: currentOperationType && isCompatibleWithCurrentOperation(field) ? currentOperationType : operationByField.get(field).values().next().value // TODO let's remove these non-null assertion, they are very dangerous
          },
          exists,
          compatible,
          'data-test-subj': `lns-fieldOption${compatible ? '' : 'Incompatible'}-${field}`
        };
      }).sort((a, b) => b.compatible - a.compatible);
    }
    const [metaFields, nonMetaFields] = (0, _lodash.partition)(normalFields, field => {
      var _currentIndexPattern$5;
      return (_currentIndexPattern$5 = currentIndexPattern.getFieldByName(field)) === null || _currentIndexPattern$5 === void 0 ? void 0 : _currentIndexPattern$5.meta;
    });
    const [availableFields, emptyFields] = (0, _lodash.partition)(nonMetaFields, containsData);
    const constructFieldsOptions = (fieldsArr, label) => fieldsArr.length > 0 && {
      label,
      options: fieldNamesToOptions(fieldsArr)
    };
    const isTimeSeriesFields = field => {
      var _currentIndexPattern$6;
      return showTimeSeriesDimensions && ((_currentIndexPattern$6 = currentIndexPattern.getFieldByName(field)) === null || _currentIndexPattern$6 === void 0 ? void 0 : _currentIndexPattern$6.timeSeriesDimension);
    };
    const [availableTimeSeriesFields, availableNonTimeseriesFields] = (0, _lodash.partition)(availableFields, isTimeSeriesFields);
    const [emptyTimeSeriesFields, emptyNonTimeseriesFields] = (0, _lodash.partition)(emptyFields, isTimeSeriesFields);
    const timeSeriesFieldsOptions = constructFieldsOptions(
    // This group includes both available and empty fields
    availableTimeSeriesFields.concat(emptyTimeSeriesFields), _i18n.i18n.translate('xpack.lens.indexPattern.timeSeriesFieldsLabel', {
      defaultMessage: 'Time series dimensions'
    }));
    const availableFieldsOptions = constructFieldsOptions(availableNonTimeseriesFields, _i18n.i18n.translate('xpack.lens.indexPattern.availableFieldsLabel', {
      defaultMessage: 'Available fields'
    }));
    const emptyFieldsOptions = constructFieldsOptions(emptyNonTimeseriesFields, _i18n.i18n.translate('xpack.lens.indexPattern.emptyFieldsLabel', {
      defaultMessage: 'Empty fields'
    }));
    const metaFieldsOptions = constructFieldsOptions(metaFields, _i18n.i18n.translate('xpack.lens.indexPattern.metaFieldsLabel', {
      defaultMessage: 'Meta fields'
    }));
    return [...fieldNamesToOptions(specialFields), timeSeriesFieldsOptions, availableFieldsOptions, emptyFieldsOptions, metaFieldsOptions].filter(Boolean);
  }, [operationByField, incompleteOperation, selectedOperationType, currentIndexPattern, hasFieldData, markAllFieldsCompatible, showTimeSeriesDimensions]);
  return /*#__PURE__*/_react.default.createElement(_visualizationUiComponents.FieldPicker, {
    activeField: selectedOperationType && selectedField ? {
      label: (_ref = selectedOperationType && selectedField && ((_currentIndexPattern$7 = currentIndexPattern.getFieldByName(selectedField)) === null || _currentIndexPattern$7 === void 0 ? void 0 : _currentIndexPattern$7.displayName)) !== null && _ref !== void 0 ? _ref : selectedField,
      value: {
        type: 'field',
        field: selectedField
      }
    } : undefined,
    options: memoizedFieldOptions,
    onChoose: choice => {
      if (choice && choice.field !== selectedField) {
        onChoose(choice);
      }
    },
    onDelete: onDeleteColumn,
    fieldIsInvalid: Boolean(incompleteOperation || fieldIsInvalid),
    "data-test-subj": dataTestSub !== null && dataTestSub !== void 0 ? dataTestSub : 'indexPattern-dimension-field',
    "aria-describedby": ariaDescribedby,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 191,
      columnNumber: 5
    }
  });
}