"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Overview = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _sharedUxPageKibanaTemplate = require("@kbn/shared-ux-page-kibana-template");
var _sharedUxAvatarSolution = require("@kbn/shared-ux-avatar-solution");
var _sharedUxLinkRedirectApp = require("@kbn/shared-ux-link-redirect-app");
var _reactKibanaContextTheme = require("@kbn/react-kibana-context-theme");
var _sharedUxUtility = require("@kbn/shared-ux-utility");
var _classnames = _interopRequireDefault(require("classnames"));
var _common = require("../../../common");
var _add_data = require("../add_data");
var _manage_data = require("../manage_data");
var _news_feed = require("../news_feed");
var _ui_metric = require("../../lib/ui_metric");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/private/kibana_overview/public/components/overview/overview.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const sortByOrder = (featureA, featureB) => (featureA.order || Infinity) - (featureB.order || Infinity);
const Overview = ({
  newsFetchResult,
  solutions,
  features
}) => {
  var _share$url$locators$g, _share$url$locators$g2, _newsFetchResult$feed;
  const [isNewKibanaInstance, setNewKibanaInstance] = (0, _react.useState)(false);
  const [hasESData, setHasESData] = (0, _react.useState)(false);
  const [hasDataView, setHasDataView] = (0, _react.useState)(false);
  const [isLoading, setIsLoading] = (0, _react.useState)(true);
  const {
    services
  } = (0, _public.useKibana)();
  const {
    http,
    docLinks,
    dataViews,
    share,
    application,
    chrome,
    dataViewEditor,
    customBranding
  } = services;
  const addBasePath = http.basePath.prepend;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const isDarkMode = (0, _reactKibanaContextTheme.useKibanaIsDarkMode)();
  const minBreakpointM = (0, _eui.useEuiMinBreakpoint)('m');

  // Home does not have a locator implemented, so hard-code it here.
  const addDataHref = addBasePath('/app/integrations/browse');
  const devToolsHref = (_share$url$locators$g = share.url.locators.get('CONSOLE_APP_LOCATOR')) === null || _share$url$locators$g === void 0 ? void 0 : _share$url$locators$g.useUrl({});
  const managementHref = (_share$url$locators$g2 = share.url.locators.get('MANAGEMENT_APP_LOCATOR')) === null || _share$url$locators$g2 === void 0 ? void 0 : _share$url$locators$g2.useUrl({
    sectionId: ''
  });
  const getFeaturesByCategory = category => features.filter(feature => feature.showOnHomePage && feature.category === category).sort(sortByOrder);
  const getSolutionGraphicURL = solutionId => `/plugins/kibanaReact/assets/solutions_${solutionId}.svg`;
  const findFeatureById = featureId => features.find(({
    id
  }) => id === featureId);
  const kibanaApps = features.filter(({
    solutionId
  }) => solutionId === 'kibana').sort(sortByOrder);
  const addDataFeatures = getFeaturesByCategory('data');
  const manageDataFeatures = getFeaturesByCategory('admin');
  const devTools = findFeatureById('console');
  // Show card for console if none of the manage data plugins are available, most likely in OSS
  if (manageDataFeatures.length < 1 && devTools) {
    manageDataFeatures.push(devTools);
  }
  (0, _react.useEffect)(() => {
    const fetchIsNewKibanaInstance = async () => {
      const checkData = async () => {
        const hasUserDataViewValue = await dataViews.hasData.hasUserDataView();
        const hasESDataValue = await dataViews.hasData.hasESData();
        setNewKibanaInstance(!hasUserDataViewValue && hasESDataValue || !hasESDataValue);
        setHasDataView(hasUserDataViewValue);
        setHasESData(hasESDataValue);
      };
      await checkData().catch(e => {
        setNewKibanaInstance(false);
        setHasDataView(true);
        setHasESData(true);
        setIsLoading(false);
      });
      setIsLoading(false);
    };
    fetchIsNewKibanaInstance();
  }, [dataViews]);
  const renderAppCard = appId => {
    const app = kibanaApps.find(({
      id
    }) => id === appId);
    return app ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      className: "kbnOverviewApps__item",
      key: appId,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 129,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_sharedUxLinkRedirectApp.RedirectAppLinksKibanaProvider, (0, _extends2.default)({
      coreStart: {
        application: {
          currentAppId$: application.currentAppId$,
          navigateToUrl: application.navigateToUrl
        }
      }
    }, application, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 130,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_sharedUxLinkRedirectApp.RedirectAppLinksContainer, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 139,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
      description: (app === null || app === void 0 ? void 0 : app.subtitle) || '',
      href: addBasePath(app.path),
      onClick: () => {
        (0, _ui_metric.trackUiMetric)(_ui_metric.METRIC_TYPE.CLICK, `app_card_${appId}`);
      },
      image: addBasePath(`/plugins/${_common.PLUGIN_ID}/assets/kibana_${appId}_${isDarkMode ? 'dark' : 'light'}.svg`),
      title: app.title,
      titleElement: "h3",
      titleSize: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 140,
        columnNumber: 13
      }
    })))) : null;
  };

  // Dashboard and discover are displayed in larger cards
  const mainApps = ['dashboards', 'discover'];
  const remainingApps = kibanaApps.map(({
    id
  }) => id).filter(id => !mainApps.includes(id));
  const mainAppsUserHasAccessTo = (0, _react.useMemo)(() => {
    var _application$capabili, _application$capabili2;
    const applications = [];
    if ((_application$capabili = application.capabilities.dashboard_v2) !== null && _application$capabili !== void 0 && _application$capabili.show) {
      applications.push('dashboards');
    }
    if ((_application$capabili2 = application.capabilities.discover_v2) !== null && _application$capabili2 !== void 0 && _application$capabili2.show) {
      applications.push('discover');
    }
    return applications;
  }, [application.capabilities]);
  const onDataViewCreated = () => {
    setNewKibanaInstance(false);
  };
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "center",
      alignItems: "center",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 181,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 182,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "xl",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 183,
        columnNumber: 11
      }
    })));
  }
  if (isNewKibanaInstance) {
    const analyticsServices = {
      coreStart: {
        application,
        chrome,
        docLinks,
        http,
        customBranding
      },
      dataViews: {
        ...dataViews,
        hasData: {
          ...dataViews.hasData,
          // We've already called this, so we can optimize the analytics services to
          // use the already-retrieved data to avoid a double-call.
          hasESData: () => Promise.resolve(hasESData),
          hasUserDataView: () => Promise.resolve(hasDataView)
        }
      },
      dataViewEditor,
      share
    };
    const importPromise = Promise.resolve().then(() => _interopRequireWildcard(require('@kbn/shared-ux-page-analytics-no-data')));
    const AnalyticsNoDataPageKibanaProvider = (0, _sharedUxUtility.withSuspense)(/*#__PURE__*/_react.default.lazy(() => importPromise.then(({
      AnalyticsNoDataPageKibanaProvider: NoDataProvider
    }) => {
      return {
        default: NoDataProvider
      };
    })));
    const AnalyticsNoDataPage = (0, _sharedUxUtility.withSuspense)(/*#__PURE__*/_react.default.lazy(() => importPromise.then(({
      AnalyticsNoDataPage: NoDataPage
    }) => {
      return {
        default: NoDataPage
      };
    })));
    return /*#__PURE__*/_react.default.createElement(AnalyticsNoDataPageKibanaProvider, (0, _extends2.default)({}, analyticsServices, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 230,
        columnNumber: 7
      }
    }), /*#__PURE__*/_react.default.createElement(AnalyticsNoDataPage, {
      onDataViewCreated: onDataViewCreated,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 231,
        columnNumber: 9
      }
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate, {
    css: styles(euiTheme, minBreakpointM),
    pageHeader: {
      iconType: 'logoKibana',
      pageTitle: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        defaultMessage: "Analytics",
        id: "kibanaOverview.header.title",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 241,
          columnNumber: 20
        }
      }),
      rightSideItems: (0, _public.overviewPageActions)({
        addDataHref,
        application,
        devToolsHref,
        hidden: isNewKibanaInstance,
        managementHref,
        showDevToolsLink: !!devTools,
        showManagementLink: !!manageDataFeatures
      }),
      bottomBorder: true
    },
    panelled: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 237,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Section, {
    bottomBorder: true,
    "aria-labelledby": "kbnOverviewApps__title",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 255,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 256,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: "kbnOverviewApps__title",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 257,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "kibanaOverview.apps.title",
    defaultMessage: "Explore these apps",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 258,
      columnNumber: 13
    }
  }))), mainAppsUserHasAccessTo.length ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    className: "kbnOverviewMainApps",
    justifyContent: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 264,
      columnNumber: 13
    }
  }, mainAppsUserHasAccessTo.map(renderAppCard)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 268,
      columnNumber: 13
    }
  })) : null, remainingApps.length ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    className: "kbnOverviewRemainingApps",
    justifyContent: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 273,
      columnNumber: 11
    }
  }, remainingApps.map(renderAppCard)) : null), /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Section, {
    bottomBorder: true,
    paddingSize: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 279,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexStart",
    className: (0, _classnames.default)({
      'kbnOverviewSupplements--noNews': !(newsFetchResult !== null && newsFetchResult !== void 0 && (_newsFetchResult$feed = newsFetchResult.feedItems) !== null && _newsFetchResult$feed !== void 0 && _newsFetchResult$feed.length)
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 280,
      columnNumber: 9
    }
  }, newsFetchResult && newsFetchResult.feedItems.length ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 287,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_news_feed.NewsFeed, {
    newsFetchResult: newsFetchResult,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 288,
      columnNumber: 15
    }
  })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 292,
      columnNumber: 11
    }
  }, solutions.length ? /*#__PURE__*/_react.default.createElement("section", {
    "aria-labelledby": "kbnOverviewMore__title",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 294,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 295,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: "kbnOverviewMore__title",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 296,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "kibanaOverview.more.title",
    defaultMessage: "Do more with Elastic",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 297,
      columnNumber: 21
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 304,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 306,
      columnNumber: 17
    }
  }, solutions.map(({
    id,
    title,
    description,
    icon,
    path
  }) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "kbnOverviewItem",
    key: id,
    className: "kbnOverviewItemSolution",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 308,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxLinkRedirectApp.RedirectAppLinksKibanaProvider, (0, _extends2.default)({
    coreStart: {
      application: {
        currentAppId$: application.currentAppId$,
        navigateToUrl: application.navigateToUrl
      }
    }
  }, application, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 313,
      columnNumber: 23
    }
  }), /*#__PURE__*/_react.default.createElement(_sharedUxLinkRedirectApp.RedirectAppLinksContainer, {
    className: "kbnRedirectAppLinkImage",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 322,
      columnNumber: 25
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    className: `kbnOverviewSolution--${id}`,
    description: description ? description : '',
    href: addBasePath(path),
    icon: /*#__PURE__*/_react.default.createElement(_sharedUxAvatarSolution.KibanaSolutionAvatar, {
      name: title,
      iconType: icon,
      size: "xl",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 327,
        columnNumber: 35
      }
    }),
    image: addBasePath(getSolutionGraphicURL((0, _lodash.snakeCase)(id))),
    title: title,
    titleElement: "h3",
    titleSize: "xs",
    onClick: () => {
      (0, _ui_metric.trackUiMetric)(_ui_metric.METRIC_TYPE.CLICK, `solution_panel_${id}`);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 323,
      columnNumber: 27
    }
  }))))))) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    css: (0, _react2.css)({
      ...(addDataFeatures.length > 1 && manageDataFeatures.length > 1 ? {
        flexDirection: 'column'
      } : {})
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 343,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 350,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_add_data.AddData, {
    addBasePath: addBasePath,
    features: addDataFeatures,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 351,
      columnNumber: 19
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 354,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_manage_data.ManageData, {
    addBasePath: addBasePath,
    features: manageDataFeatures,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 355,
      columnNumber: 19
    }
  })))))), /*#__PURE__*/_react.default.createElement(_public.OverviewPageFooter, {
    addBasePath: addBasePath,
    path: _common.PLUGIN_PATH,
    onSetDefaultRoute: () => {
      (0, _ui_metric.trackUiMetric)(_ui_metric.METRIC_TYPE.CLICK, 'set_kibana_overview_as_default_route');
    },
    onChangeDefaultRoute: () => {
      (0, _ui_metric.trackUiMetric)(_ui_metric.METRIC_TYPE.CLICK, 'change_to_different_default_route');
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 363,
      columnNumber: 7
    }
  }));
};
exports.Overview = Overview;
const styles = (euiTheme, minBreakpointM) => (0, _react2.css)({
  '.kbnRedirectAppLinkImage': {
    '.enterpriseSearch': {
      '.euiCard__image': {
        backgroundColor: euiTheme.colors.warning
      }
    },
    '.observability': {
      '.euiCard__image': {
        backgroundColor: euiTheme.colors.accent
      }
    },
    '.securitySolution': {
      '.euiCard__image': {
        backgroundColor: euiTheme.colors.accentSecondary
      }
    }
  },
  '.kbnOverviewItemSolution': {
    [minBreakpointM]: {
      maxWidth: `calc(33.333% - ${euiTheme.size.l})`
    }
  },
  '.kbnOverviewRemainingApps': {
    '.kbnOverviewApps__item': {
      [minBreakpointM]: {
        maxWidth: `calc(25% - ${euiTheme.size.l})`
      }
    }
  },
  '.kbnOverviewMainApps': {
    '.kbnOverviewApps__item': {
      [minBreakpointM]: {
        maxWidth: `calc(50% - ${euiTheme.size.l})`
      }
    }
  },
  '.kbnOverviewSupplements--noNews h2': {
    [minBreakpointM]: {
      textAlign: 'center'
    }
  }
});