"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ShardFailureTable = ShardFailureTable;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _shard_failure_details = require("./shard_failure_details");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/inspector/public/views/requests/components/details/clusters_view/clusters_table/shards_view/shard_failure_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function getRowId(failure) {
  return `${failure.shard}${failure.index}`;
}
function ShardFailureTable({
  failures
}) {
  const [expandedRows, setExpandedRows] = (0, _react.useState)({});
  const toggleDetails = rowId => {
    const nextExpandedRows = {
      ...expandedRows
    };
    if (rowId in nextExpandedRows) {
      delete nextExpandedRows[rowId];
    } else {
      const shardFailure = failures.find(failure => rowId === getRowId(failure));
      nextExpandedRows[rowId] = shardFailure ? /*#__PURE__*/_react.default.createElement(_shard_failure_details.ShardFailureDetails, {
        failure: shardFailure,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 42,
          columnNumber: 9
        }
      }) : null;
    }
    setExpandedRows(nextExpandedRows);
  };
  const columns = [{
    field: 'shard',
    name: _i18n.i18n.translate('inspector.requests.clusters.shards.table.shardLabel', {
      defaultMessage: 'Shard'
    }),
    render: (shard, item) => {
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        onClick: () => toggleDetails(item.rowId),
        "aria-label": item.rowId in expandedRows ? _i18n.i18n.translate('inspector.requests.clusters.shards.table.collapseRow', {
          defaultMessage: 'Collapse table row to hide shard details'
        }) : _i18n.i18n.translate('inspector.requests.clusters.shards.table.expandRow', {
          defaultMessage: 'Expand table row to view shard details'
        }),
        iconType: item.rowId in expandedRows ? 'arrowDown' : 'arrowRight',
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 57,
          columnNumber: 13
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "xs",
        color: "subdued",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 70,
          columnNumber: 13
        }
      }, shard));
    },
    width: '20%'
  }, {
    field: 'index',
    name: _i18n.i18n.translate('inspector.requests.clusters.shards.table.indexLabel', {
      defaultMessage: 'Index'
    }),
    render: index => index ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      color: "subdued",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 85,
        columnNumber: 11
      }
    }, index) : null
  }, {
    field: 'failureType',
    name: _i18n.i18n.translate('inspector.requests.clusters.shards.table.failureTypeLabel', {
      defaultMessage: 'Failure type'
    }),
    render: failureType => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      color: "subdued",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 96,
        columnNumber: 9
      }
    }, failureType)
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    items: failures.map(failure => {
      return {
        rowId: getRowId(failure),
        shard: failure.shard,
        index: failure.index,
        failureType: failure.reason.type
      };
    }),
    itemIdToExpandedRowMap: expandedRows,
    itemId: "rowId",
    columns: columns,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 5
    }
  });
}