"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getIndexPatternMock = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Returns forced **Partial** IndexPattern for use in tests
 */
const getIndexPatternMock = () => {
  return Promise.resolve({
    id: 'mockIndexPattern',
    title: 'mockIndexPattern',
    fields: [{
      name: 'keywordField',
      type: 'string',
      aggregatable: true
    }, {
      name: 'textField',
      type: 'string',
      aggregatable: false
    }, {
      name: 'numberField',
      type: 'number',
      aggregatable: true
    }]
  });
};
exports.getIndexPatternMock = getIndexPatternMock;