"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ControlEditor = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _range_control_editor = require("./range_control_editor");
var _list_control_editor = require("./list_control_editor");
var _editor_utils = require("../../editor_utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/private/input_control_vis/public/components/editor/control_editor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class ControlEditorUi extends _react.PureComponent {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "changeLabel", event => {
      this.props.handleLabelChange(this.props.controlIndex, event.target.value);
    });
    (0, _defineProperty2.default)(this, "removeControl", () => {
      this.props.handleRemoveControl(this.props.controlIndex);
    });
    (0, _defineProperty2.default)(this, "moveUpControl", () => {
      this.props.moveControl(this.props.controlIndex, -1);
    });
    (0, _defineProperty2.default)(this, "moveDownControl", () => {
      this.props.moveControl(this.props.controlIndex, 1);
    });
    (0, _defineProperty2.default)(this, "changeIndexPattern", indexPatternId => {
      this.props.handleIndexPatternChange(this.props.controlIndex, indexPatternId);
    });
    (0, _defineProperty2.default)(this, "changeFieldName", fieldName => {
      this.props.handleFieldNameChange(this.props.controlIndex, fieldName);
    });
  }
  renderEditor() {
    let controlEditor = null;
    switch (this.props.controlParams.type) {
      case _editor_utils.CONTROL_TYPES.LIST:
        controlEditor = /*#__PURE__*/_react.default.createElement(_list_control_editor.ListControlEditor, {
          controlIndex: this.props.controlIndex,
          controlParams: this.props.controlParams,
          handleIndexPatternChange: this.changeIndexPattern,
          handleFieldNameChange: this.changeFieldName,
          getIndexPattern: this.props.getIndexPattern,
          handleOptionsChange: this.props.handleOptionsChange,
          parentCandidates: this.props.parentCandidates,
          handleParentChange: this.props.handleParentChange,
          deps: this.props.deps,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 86,
            columnNumber: 11
          }
        });
        break;
      case _editor_utils.CONTROL_TYPES.RANGE:
        controlEditor = /*#__PURE__*/_react.default.createElement(_range_control_editor.RangeControlEditor, {
          controlIndex: this.props.controlIndex,
          controlParams: this.props.controlParams,
          handleIndexPatternChange: this.changeIndexPattern,
          handleFieldNameChange: this.changeFieldName,
          getIndexPattern: this.props.getIndexPattern,
          handleOptionsChange: this.props.handleOptionsChange,
          deps: this.props.deps,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 101,
            columnNumber: 11
          }
        });
        break;
      default:
        throw new Error(`Unhandled control editor type ${this.props.controlParams.type}`);
    }
    const labelId = `controlLabel${this.props.controlIndex}`;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 118,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      id: labelId,
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "inputControl.editor.controlEditor.controlLabel",
        defaultMessage: "Control Label",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 122,
          columnNumber: 13
        }
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 119,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      value: this.props.controlParams.label,
      onChange: this.changeLabel,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 128,
        columnNumber: 11
      }
    })), controlEditor);
  }
  renderEditorButtons() {
    return /*#__PURE__*/_react.default.createElement("div", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 138,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "aria-label": this.props.intl.formatMessage({
        id: 'inputControl.editor.controlEditor.moveControlUpAriaLabel',
        defaultMessage: 'Move control up'
      }),
      color: "primary",
      onClick: this.moveUpControl,
      iconType: "sortUp",
      "data-test-subj": `inputControlEditorMoveUpControl${this.props.controlIndex}`,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 139,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "aria-label": this.props.intl.formatMessage({
        id: 'inputControl.editor.controlEditor.moveControlDownAriaLabel',
        defaultMessage: 'Move control down'
      }),
      color: "primary",
      onClick: this.moveDownControl,
      iconType: "sortDown",
      "data-test-subj": `inputControlEditorMoveDownControl${this.props.controlIndex}`,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 149,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "aria-label": this.props.intl.formatMessage({
        id: 'inputControl.editor.controlEditor.removeControlAriaLabel',
        defaultMessage: 'Remove control'
      }),
      color: "danger",
      onClick: this.removeControl,
      iconType: "cross",
      "data-test-subj": `inputControlEditorRemoveControl${this.props.controlIndex}`,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 159,
        columnNumber: 9
      }
    }));
  }
  render() {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      grow: false,
      css: ({
        euiTheme
      }) => (0, _react2.css)({
        zIndex: 1,
        marginBottom: euiTheme.size.base
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 175,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
      id: "controlEditorAccordion",
      buttonContent: (0, _editor_utils.getTitle)(this.props.controlParams, this.props.controlIndex),
      extraAction: this.renderEditorButtons(),
      initialIsOpen: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 184,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 190,
        columnNumber: 11
      }
    }), this.renderEditor()));
  }
}
const ControlEditor = exports.ControlEditor = (0, _i18nReact.injectI18n)(ControlEditorUi);