"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FlyoutFooter = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ingest_pipelines/public/application/sections/pipelines_list/flyout_content/flyout_footer.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const useStyles = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return {
    deleteAction: (0, _react2.css)`
      color: ${euiTheme.colors.dangerText};
    `,
    contextMenu: (0, _react2.css)`
      width: 150px;
    `
  };
};
const FlyoutFooter = ({
  pipeline,
  onEditClick,
  onCloneClick,
  onDeleteClick,
  renderActions,
  renderViewTreeButton,
  onViewTreeClick
}) => {
  const styles = useStyles();
  const [showPopover, setShowPopover] = (0, _react.useState)(false);
  const popoverActions = [
  /**
   * Duplicate pipeline
   */
  {
    name: _i18n.i18n.translate('xpack.ingestPipelines.list.pipelineDetails.duplicateActionLabel', {
      defaultMessage: 'Duplicate'
    }),
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "copy",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 68,
        columnNumber: 13
      }
    }),
    onClick: () => onCloneClick(pipeline.name)
  },
  /**
   * Delete pipeline
   */
  {
    name: _i18n.i18n.translate('xpack.ingestPipelines.list.pipelineDetails.deleteActionLabel', {
      defaultMessage: 'Delete'
    }),
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "trash",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 78,
        columnNumber: 13
      }
    }),
    'data-test-subj': 'deletePipelineButton',
    onClick: () => {
      setShowPopover(false);
      onDeleteClick([pipeline]);
    },
    css: styles.deleteAction
  }];
  const actionsPopoverButton = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    display: "base",
    size: "m",
    "data-test-subj": "actionsPopoverButton",
    "aria-label": _i18n.i18n.translate('xpack.ingestPipelines.list.pipelineDetails.popoverPipelineActionsAriaLabel', {
      defaultMessage: 'Other actions'
    }),
    onClick: () => setShowPopover(previousBool => !previousBool),
    iconType: "boxesVertical",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 5
    }
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 7
    }
  }, renderViewTreeButton && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onViewTreeClick,
    flush: "left",
    "data-test-subj": "viewTreeButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.ingestPipelines.list.pipelineDetails.viewTreeLabel', {
    defaultMessage: 'View full hierarchy'
  }))), renderActions && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    justifyContent: "flexEnd",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "editPipelineButton",
    "aria-label": _i18n.i18n.translate('xpack.ingestPipelines.list.pipelineDetails.editPipelineActionsAriaLabel', {
      defaultMessage: 'Edit pipeline'
    }),
    onClick: () => onEditClick(pipeline.name),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.ingestPipelines.list.pipelineDetails.editPipelineButtonLabel', {
    defaultMessage: 'Edit pipeline'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    isOpen: showPopover,
    closePopover: () => setShowPopover(false),
    button: actionsPopoverButton,
    panelPaddingSize: "none",
    repositionOnScroll: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    initialPanelId: 0,
    panels: [{
      id: 0,
      items: popoverActions
    }],
    css: styles.contextMenu,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 17
    }
  }))))));
};
exports.FlyoutFooter = FlyoutFooter;