"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Inference = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../../../../shared_imports");
var _target_field = require("./common_fields/target_field");
var _shared = require("./shared");
var _field_components = require("../field_components");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ingest_pipelines/public/application/components/pipeline_editor/components/processor_form/processors/inference.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const {
  emptyField
} = _shared_imports.fieldValidators;
const INFERENCE_CONFIG_DOCS = {
  documentation: {
    linkLabel: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.inferenceForm.inferenceConfigField.documentationLinkLabel', {
      defaultMessage: 'documentation'
    })
  }
};
function getInferenceConfigHelpText(documentationDocsLink) {
  return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ingestPipelines.pipelineEditor.inferenceForm.inferenceConfigurationHelpText",
    defaultMessage: "Contains the inference type and its options. Refer to the {documentation} for the available configuration options.",
    values: {
      documentation: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        external: true,
        target: "_blank",
        href: documentationDocsLink,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 46,
          columnNumber: 11
        }
      }, INFERENCE_CONFIG_DOCS.documentation.linkLabel)
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 5
    }
  });
}
const fieldsConfig = {
  /* Required fields config */
  model_id: {
    type: _shared_imports.FIELD_TYPES.TEXT,
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.inferenceForm.modelIDFieldLabel', {
      defaultMessage: 'Deployment, inference, or model ID'
    }),
    deserializer: String,
    helpText: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.inferenceForm.modelIDFieldHelpText', {
      defaultMessage: 'ID of the deployment, the inference endpoint, or the model to infer against.'
    }),
    validations: [{
      validator: emptyField(_i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.inferenceForm.patternRequiredError', {
        defaultMessage: 'A deployment, an inference, or a model ID value is required.'
      }))
    }]
  },
  /* Optional fields config */
  field_map: {
    type: _shared_imports.FIELD_TYPES.TEXT,
    deserializer: _shared.to.xJsonString,
    serializer: _shared.from.optionalXJson,
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.inferenceForm.fieldMapLabel', {
      defaultMessage: 'Field map (optional)'
    }),
    helpText: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.inferenceForm.fieldMapHelpText', {
      defaultMessage: 'Maps document field names to the known field names of the model. Takes precedence over any mappings in the model.'
    }),
    validations: [{
      validator: (0, _shared.isXJsonField)(_i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.inferenceForm.fieldMapInvalidJSONError', {
        defaultMessage: 'Invalid JSON'
      }), {
        allowEmptyString: true
      })
    }]
  },
  inference_config: {
    type: _shared_imports.FIELD_TYPES.TEXT,
    deserializer: _shared.to.xJsonString,
    serializer: _shared.from.optionalXJson,
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.inferenceForm.inferenceConfigLabel', {
      defaultMessage: 'Inference configuration (optional)'
    }),
    validations: [{
      validator: (0, _shared.isXJsonField)(_i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.grokForm.patternsDefinitionsInvalidJSONError', {
        defaultMessage: 'Invalid JSON'
      }), {
        allowEmptyString: true
      })
    }]
  }
};
const Inference = () => {
  const {
    services
  } = (0, _shared_imports.useKibana)();
  const documentationDocsLink = services.documentation.getDocumentationUrl();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    config: fieldsConfig.model_id,
    component: _shared_imports.Field,
    path: "fields.model_id",
    "data-test-subj": "inferenceModelId",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_target_field.TargetField, {
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.pipelineEditor.inferenceForm.targetFieldHelpText",
      defaultMessage: "Field used to contain inference processor results. Defaults to {targetField}.",
      values: {
        targetField: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 157,
            columnNumber: 36
          }
        }, 'ml.inference.<processor_tag>')
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 154,
        columnNumber: 11
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    config: fieldsConfig.field_map,
    component: _field_components.XJsonEditor,
    componentProps: {
      editorProps: {
        'data-test-subj': 'fieldMap',
        height: _shared.EDITOR_PX_HEIGHT.medium,
        options: {
          minimap: {
            enabled: false
          }
        }
      }
    },
    path: "fields.field_map",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    config: {
      ...fieldsConfig.inference_config,
      helpText: getInferenceConfigHelpText(documentationDocsLink)
    },
    component: _field_components.XJsonEditor,
    componentProps: {
      editorProps: {
        'data-test-subj': 'inferenceConfig',
        height: _shared.EDITOR_PX_HEIGHT.medium,
        options: {
          minimap: {
            enabled: false
          }
        }
      }
    },
    path: "fields.inference_config",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 7
    }
  }));
};
exports.Inference = Inference;