"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CommonProcessorFields = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _monaco = require("@kbn/monaco");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../../../../../shared_imports");
var _field_components = require("../../field_components");
var _shared = require("../shared");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ingest_pipelines/public/application/components/pipeline_editor/components/processor_form/processors/common_fields/common_processor_fields.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ignoreFailureConfig = {
  defaultValue: false,
  deserializer: _shared.to.booleanOrUndef,
  serializer: _shared.from.undefinedIfValue(false),
  label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.commonFields.ignoreFailureFieldLabel', {
    defaultMessage: 'Ignore failures for this processor'
  }),
  type: _shared_imports.FIELD_TYPES.TOGGLE
};
const ifConfig = {
  serializer: _shared.from.emptyStringToUndefined,
  label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.commonFields.ifFieldLabel', {
    defaultMessage: 'Condition (optional)'
  }),
  helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ingestPipelines.pipelineEditor.commonFields.ifFieldHelpText",
    defaultMessage: "An {if} condition written as a Painless script: {exampleCondition}",
    values: {
      if: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 44,
          columnNumber: 13
        }
      }, 'if'),
      exampleCondition: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 45,
          columnNumber: 27
        }
      }, "ctx?.network?.name == 'Guest'")
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 5
    }
  }),
  type: _shared_imports.FIELD_TYPES.TEXT
};
const tagConfig = {
  serializer: _shared.from.emptyStringToUndefined,
  label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.commonFields.tagFieldLabel', {
    defaultMessage: 'Tag (optional)'
  }),
  helpText: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.commonFields.tagFieldHelpText', {
    defaultMessage: 'An identifier for the processor. Useful for debugging and metrics.'
  }),
  type: _shared_imports.FIELD_TYPES.TEXT
};
const CommonProcessorFields = () => {
  const suggestionProvider = _monaco.PainlessLang.getSuggestionProvider('processor_conditional');
  return /*#__PURE__*/_react.default.createElement("section", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    "data-test-subj": "ifField",
    config: ifConfig,
    component: _field_components.TextEditor,
    componentProps: {
      editorProps: {
        languageId: _monaco.PainlessLang.ID,
        suggestionProvider,
        height: _shared.EDITOR_PX_HEIGHT.extraSmall,
        options: {
          lineNumbers: 'off',
          minimap: {
            enabled: false
          }
        }
      }
    },
    path: "fields.if",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    "data-test-subj": "tagField",
    config: tagConfig,
    component: _shared_imports.Field,
    path: "fields.tag",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    "data-test-subj": "ignoreFailureSwitch",
    config: ignoreFailureConfig,
    component: _shared_imports.ToggleField,
    path: "fields.ignore_failure",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 7
    }
  }));
};
exports.CommonProcessorFields = CommonProcessorFields;