"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddProcessorForm = void 0;
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../../../shared_imports");
var _shared = require("../shared");
var _documentation_button = require("./documentation_button");
var _processor_settings_fields = require("./processor_settings_fields");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ingest_pipelines/public/application/components/pipeline_editor/components/processor_form/add_processor_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const addButtonLabel = _i18n.i18n.translate('xpack.ingestPipelines.addProcessorFormOnFailureFlyout.addButtonLabel', {
  defaultMessage: 'Add processor'
});
const cancelButtonLabel = _i18n.i18n.translate('xpack.ingestPipelines.addProcesorFormOnFailureFlyout.cancelButtonLabel', {
  defaultMessage: 'Cancel'
});
const getFlyoutTitle = isOnFailure => {
  return isOnFailure ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ingestPipelines.settingsFormOnFailureFlyout.configureOnFailureTitle",
    defaultMessage: "Add on-failure processor",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 5
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ingestPipelines.settingsFormOnFailureFlyout.configureTitle",
    defaultMessage: "Add processor",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 5
    }
  });
};
const AddProcessorForm = ({
  isOnFailure,
  onOpen,
  form,
  esDocsBasePath,
  closeFlyout,
  handleSubmit,
  buttonRef
}) => {
  (0, _react.useEffect)(() => {
    onOpen();
  }, [] /* eslint-disable-line react-hooks/exhaustive-deps */);
  const isFormDirty = (0, _shared_imports.useFormIsModified)({
    form
  });
  const pipelineTitleId = (0, _eui.useGeneratedHtmlId)();
  return /*#__PURE__*/_react.default.createElement(_shared_imports.Form, {
    "data-test-subj": "addProcessorForm",
    form: form,
    onSubmit: handleSubmit,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    size: "m",
    maxWidth: 720,
    onClose: closeFlyout,
    outsideClickCloses: !isFormDirty,
    "aria-labelledby": pipelineTitleId,
    focusTrapProps: {
      returnFocus: triggerElement => {
        if (buttonRef !== null && buttonRef !== void 0 && buttonRef.current) {
          // Using setTimeout here to postpone focus until after the flyout has finished unmounting and cleaning up its focus traps.
          // Without this, the focus gets applied too early and it's overridden by the browser's default focus behavior.
          setTimeout(() => {
            var _buttonRef$current;
            (_buttonRef$current = buttonRef.current) === null || _buttonRef$current === void 0 ? void 0 : _buttonRef$current.focus();
          }, 0);
          return false;
        }
        return true;
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m",
    "data-test-subj": "configurePipelineHeader",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: pipelineTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 19
    }
  }, getFlyoutTitle(isOnFailure))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_shared_imports.FormDataProvider, {
    pathsToWatch: "type",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 15
    }
  }, ({
    type
  }) => {
    const formDescriptor = (0, _shared.getProcessorDescriptor)(type);
    if (formDescriptor) {
      return /*#__PURE__*/_react.default.createElement(_documentation_button.DocumentationButton, {
        processorLabel: formDescriptor.label,
        docLink: formDescriptor.docLinkPath,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 124,
          columnNumber: 23
        }
      });
    }
    return null;
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_processor_settings_fields.ProcessorSettingsFields, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: closeFlyout,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 15
    }
  }, cancelButtonLabel)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    disabled: !form.isValid && form.isSubmitted || form.isSubmitting,
    "data-test-subj": "submitButton",
    onClick: async () => {
      await handleSubmit();
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 15
    }
  }, addButtonLabel))))));
};
exports.AddProcessorForm = AddProcessorForm;