"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricsExplorerChartOptions = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _reactHooks = require("@kbn/react-hooks");
var _use_metrics_explorer_options = require("../hooks/use_metrics_explorer_options");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/pages/metrics/metrics_explorer/components/chart_options.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MetricsExplorerChartOptions = ({
  chartOptions,
  onChange
}) => {
  const [isPopoverOpen, {
    toggle: togglePopover
  }] = (0, _reactHooks.useBoolean)(false);
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "aria-label": _i18n.i18n.translate('xpack.infra.metricsExplorerChartOptions.customizeButton.ariaLabel', {
      defaultMessage: 'Customize'
    }),
    iconSide: "left",
    size: "s",
    iconType: "eye",
    onClick: togglePopover,
    "data-test-subj": "metricsExplorer-customize",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.metricsExplorer.customizeChartOptions",
    defaultMessage: "Customize",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 7
    }
  }));
  const yAxisRadios = [{
    id: _use_metrics_explorer_options.MetricsExplorerYAxisMode.auto,
    label: _i18n.i18n.translate('xpack.infra.metricsExplorer.chartOptions.autoLabel', {
      defaultMessage: 'Automatic (min to max)'
    })
  }, {
    id: _use_metrics_explorer_options.MetricsExplorerYAxisMode.fromZero,
    label: _i18n.i18n.translate('xpack.infra.metricsExplorer.chartOptions.fromZeroLabel', {
      defaultMessage: 'From zero (0 to max)'
    })
  }];
  const typeRadios = [{
    'data-test-subj': 'metricsExplorer-chartRadio-line',
    id: _use_metrics_explorer_options.MetricsExplorerChartType.line,
    label: _i18n.i18n.translate('xpack.infra.metricsExplorer.chartOptions.lineLabel', {
      defaultMessage: 'Line'
    })
  }, {
    'data-test-subj': 'metricsExplorer-chartRadio-area',
    id: _use_metrics_explorer_options.MetricsExplorerChartType.area,
    label: _i18n.i18n.translate('xpack.infra.metricsExplorer.chartOptions.areaLabel', {
      defaultMessage: 'Area'
    })
  }, {
    'data-test-subj': 'metricsExplorer-chartRadio-bar',
    id: _use_metrics_explorer_options.MetricsExplorerChartType.bar,
    label: _i18n.i18n.translate('xpack.infra.metricsExplorer.chartOptions.barLabel', {
      defaultMessage: 'Bar'
    })
  }];
  const handleYAxisChange = (0, _react.useCallback)(id => {
    onChange({
      ...chartOptions,
      yAxisMode: id
    });
  }, [chartOptions, onChange]);
  const handleTypeChange = (0, _react.useCallback)(id => {
    onChange({
      ...chartOptions,
      type: id
    });
  }, [chartOptions, onChange]);
  const handleStackChange = (0, _react.useCallback)(e => {
    onChange({
      ...chartOptions,
      stack: e.target.checked
    });
  }, [chartOptions, onChange]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "MetricExplorerChartOptionsPopover",
    button: button,
    isOpen: isPopoverOpen,
    closePopover: togglePopover,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "rowCompressed",
    label: _i18n.i18n.translate('xpack.infra.metricsExplorer.chartOptions.typeLabel', {
      defaultMessage: 'Chart style'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiRadioGroup, {
    "data-test-subj": "infraMetricsExplorerChartOptionsRadioGroup",
    compressed: true,
    options: typeRadios,
    idSelected: chartOptions.type,
    onChange: handleTypeChange,
    name: "chartStyle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "rowCompressed",
    label: _i18n.i18n.translate('xpack.infra.metricsExplorer.chartOptions.stackLabel', {
      defaultMessage: 'Stack series'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: _i18n.i18n.translate('xpack.infra.metricsExplorer.chartOptions.stackSwitchLabel', {
      defaultMessage: 'Stack'
    }),
    checked: chartOptions.stack,
    onChange: handleStackChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "rowCompressed",
    label: _i18n.i18n.translate('xpack.infra.metricsExplorer.chartOptions.yAxisDomainLabel', {
      defaultMessage: 'Y Axis Domain'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiRadioGroup, {
    "data-test-subj": "infraMetricsExplorerChartOptionsRadioGroup",
    compressed: true,
    options: yAxisRadios,
    idSelected: chartOptions.yAxisMode,
    onChange: handleYAxisChange,
    name: "yAxisDomain",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 11
    }
  }))));
};
exports.MetricsExplorerChartOptions = MetricsExplorerChartOptions;