"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GroupName = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/pages/metrics/inventory_view/components/waffle/group_name.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const GroupName = ({
  onDrilldown,
  group,
  isChild,
  options,
  nodeType
}) => {
  const [a11yAnnouncement, setA11yAnnouncement] = (0, _react.useState)('');
  const handleClick = (0, _react.useCallback)(event => {
    event.preventDefault();
    if (options.groupBy.length === 0) {
      setA11yAnnouncement(_i18n.i18n.translate('xpack.infra.inventory.groupBy.noChangeMessage', {
        defaultMessage: 'No changes were made when selecting {group}.',
        values: {
          group: group.name
        }
      }));
      return;
    }
    setA11yAnnouncement(_i18n.i18n.translate('xpack.infra.inventory.groupBy.groupingByMessage', {
      defaultMessage: 'Grouping by {group}...',
      values: {
        group: group.name
      }
    }));
    const currentPath = isChild && options.groupBy.length > 1 ? options.groupBy[1] : options.groupBy[0];
    onDrilldown(`${currentPath.field}: "${group.name}"`);
  }, [group.name, isChild, onDrilldown, options.groupBy]);
  const buttonStyle = {
    fontSize: isChild ? '0.85em' : '1em'
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    "aria-live": "polite",
    role: "status",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 9
    }
  }, a11yAnnouncement)), /*#__PURE__*/_react.default.createElement(GroupNameContainer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(Inner, {
    isChild: isChild,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(Name, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: group.name,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "aria-label": _i18n.i18n.translate('xpack.infra.inventory.groupBySelectorButton.ariaLabel', {
      defaultMessage: 'Group by {group}',
      values: {
        group: group.name
      }
    }),
    css: buttonStyle,
    onClick: handleClick,
    "data-test-subj": "groupNameButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 15
    }
  }, group.name))), /*#__PURE__*/_react.default.createElement(Count, {
    "aria-label": _i18n.i18n.translate('xpack.infra.inventory.groupByCount.ariaLabel', {
      defaultMessage: '{count} {nodeType} in this group',
      values: {
        nodeType,
        count: group.count
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 11
    }
  }, group.count))));
};
exports.GroupName = GroupName;
const GroupNameContainer = _styled.default.div`
  position: relative;
  text-align: center;
  font-size: ${props => (0, _eui.useEuiFontSize)('m').fontSize};
  margin-bottom: 5px;
  top: 20px;
  display: flex;
  justify-content: center;
  padding: 0 10px;
`;
const Inner = _styled.default.div`
  border: ${props => props.theme.euiTheme.border.thin};
  background-color: ${props => props.isChild ? props.theme.euiTheme.colors.lightestShade : props.theme.euiTheme.colors.emptyShade};
  border-radius: 4px;
  box-shadow: 0px 2px 0px 0px ${props => props.theme.euiTheme.border.color};
  display: flex;
  align-items: center;
  justify-content: center;
  overflow: hidden;
`;
const Name = _styled.default.div`
  flex: 1 1 auto;
  padding: 6px 10px;
  overflow: hidden;
  text-overflow: ellipsis;
  white-space: nowrap;
`;
const Count = _styled.default.div`
  flex: 0 0 auto;
  border-left: ${props => props.theme.euiTheme.border.thin};
  padding: 6px 10px;
  font-size: ${() => (0, _eui.useEuiFontSize)('xs').fontSize};
  font-weight: normal;
`;