"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mapToUrlState = exports.WithMetricsExplorerOptionsUrlState = void 0;
var _saferLodashSet = require("@kbn/safer-lodash-set");
var _react = _interopRequireWildcard(require("react"));
var _ThrowReporter = require("io-ts/lib/ThrowReporter");
var _url_state = require("../../utils/url_state");
var _use_metrics_explorer_options = require("../../pages/metrics/metrics_explorer/hooks/use_metrics_explorer_options");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/containers/metrics_explorer/with_metrics_explorer_options_url_state.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const WithMetricsExplorerOptionsUrlState = () => {
  const {
    options,
    chartOptions,
    setChartOptions,
    timeRange,
    setOptions: setRawOptions,
    setTimeRange
  } = (0, _use_metrics_explorer_options.useMetricsExplorerOptionsContainerContext)();
  const setOptions = value => {
    setRawOptions(value);
  };
  const urlState = (0, _react.useMemo)(() => ({
    options,
    chartOptions,
    timerange: timeRange
  }), [options, chartOptions, timeRange]);
  const handleChange = newUrlState => {
    if (newUrlState && newUrlState.options) {
      setOptions(newUrlState.options);
    }
    if (newUrlState && newUrlState.timerange) {
      setTimeRange(newUrlState.timerange);
    }
    if (newUrlState && newUrlState.chartOptions) {
      setChartOptions(newUrlState.chartOptions);
    }
  };
  return /*#__PURE__*/_react.default.createElement(_url_state.UrlStateContainer, {
    urlState: urlState,
    urlStateKey: "metricsExplorer",
    mapToUrlState: mapToUrlState,
    onChange: handleChange,
    onInitialize: handleChange,
    populateWithInitialState: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 5
    }
  });
};
exports.WithMetricsExplorerOptionsUrlState = WithMetricsExplorerOptionsUrlState;
function isMetricExplorerOptions(subject) {
  const result = _use_metrics_explorer_options.metricsExplorerOptionsRT.decode(subject);
  try {
    _ThrowReporter.ThrowReporter.report(result);
    return true;
  } catch (e) {
    return false;
  }
}
function isMetricExplorerChartOptions(subject) {
  const result = _use_metrics_explorer_options.metricsExplorerChartOptionsRT.decode(subject);
  try {
    _ThrowReporter.ThrowReporter.report(result);
    return true;
  } catch (e) {
    return false;
  }
}
function isMetricExplorerTimeOption(subject) {
  const result = _use_metrics_explorer_options.metricsExplorerTimeOptionsRT.decode(subject);
  try {
    _ThrowReporter.ThrowReporter.report(result);
    return true;
  } catch (e) {
    return false;
  }
}
const mapToUrlState = value => {
  const finalState = {};
  if (value) {
    if (value.options && isMetricExplorerOptions(value.options)) {
      value.options.source = 'url';
      (0, _saferLodashSet.set)(finalState, 'options', value.options);
    }
    if (value.timerange && isMetricExplorerTimeOption(value.timerange)) {
      (0, _saferLodashSet.set)(finalState, 'timerange', value.timerange);
    }
    if (value.chartOptions && isMetricExplorerChartOptions(value.chartOptions)) {
      (0, _saferLodashSet.set)(finalState, 'chartOptions', value.chartOptions);
    }
    return finalState;
  }
};
exports.mapToUrlState = mapToUrlState;