"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.schemaTranslationMap = exports.SchemaSelector = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/metrics-data-access-plugin/common");
var _i18nReact = require("@kbn/i18n-react");
var _use_kibana = require("../hooks/use_kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/components/schema_selector.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SCHEMA_NOT_AVAILABLE = _i18n.i18n.translate('xpack.infra.schemaSelector.notAvailable', {
  defaultMessage: 'Selected schema is not available for this query.'
});
const PrependLabel = () => {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "none",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("strong", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.infra.schemaSelector.label', {
    defaultMessage: 'Schema'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "infraSchemaSelectorHelpButton",
      "aria-label": _i18n.i18n.translate('xpack.infra.schemaSelector.helpButton.ariaLabel', {
        defaultMessage: 'See schema documentation'
      }),
      size: "s",
      onClick: () => setIsPopoverOpen(popoverValue => !popoverValue),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 53,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "question",
      color: "text",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 61,
        columnNumber: 15
      }
    })),
    isOpen: isPopoverOpen,
    closePopover: () => setIsPopoverOpen(false),
    anchorPosition: "rightCenter",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.schemaSelector.description",
    defaultMessage: "Select which data collection schema your entities are observed with.{nextLine} See {documentation} for more information.",
    values: {
      nextLine: /*#__PURE__*/_react.default.createElement("br", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 72,
          columnNumber: 25
        }
      }),
      documentation: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "infraSchemaSelectorDocumentationLink",
        href: 'https://www.elastic.co/docs/solutions/observability/infra-and-hosts/analyze-compare-hosts#select-data-collection-schema',
        target: "_blank",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 74,
          columnNumber: 17
        }
      }, _i18n.i18n.translate('xpack.infra.schemaSelector.documentation', {
        defaultMessage: 'documentation'
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 11
    }
  }))));
};
const InvalidDropdownDisplay = ({
  value
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 7
    }
  }, value), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 7
    }
  }, SCHEMA_NOT_AVAILABLE));
};
const InvalidDisplay = ({
  value
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 9
    }
  }, value)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: SCHEMA_NOT_AVAILABLE,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToken, {
    iconType: "alert",
    tabIndex: 0,
    size: "s",
    color: "euiColorVis9",
    "data-test-subj": "infraSchemaSelectorInvalidToken",
    shape: "square",
    fill: "dark",
    "aria-label": SCHEMA_NOT_AVAILABLE,
    title: _i18n.i18n.translate('xpack.infra.invalidDisplay.euiIcon.iconWithTooltipLabel', {
      defaultMessage: 'Invalid schema warning'
    }),
    css: {
      verticalAlign: 'text-bottom'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 11
    }
  }))));
};
const schemaTranslationMap = exports.schemaTranslationMap = {
  [_common.DataSchemaFormatEnum.ECS]: _i18n.i18n.translate('xpack.infra.schemaSelector.ecsDisplay', {
    defaultMessage: 'Elastic System Integration'
  }),
  [_common.DataSchemaFormatEnum.SEMCONV]: _i18n.i18n.translate('xpack.infra.schemaSelector.semconvDisplay', {
    defaultMessage: 'OpenTelemetry'
  })
};
const getInputDisplay = schema => {
  const translation = schema ? schemaTranslationMap[schema] : null;
  if (translation) {
    return translation;
  }
  return _i18n.i18n.translate('xpack.infra.schemaSelector.unknownDisplay', {
    defaultMessage: 'Unknown schema'
  });
};
const SchemaSelector = ({
  onChange,
  schemas,
  value,
  isLoading,
  isHostsView = false
}) => {
  const {
    services: {
      telemetry
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const options = (0, _react.useMemo)(() => schemas.map(schema => ({
    inputDisplay: getInputDisplay(schema),
    value: schema
  })), [schemas]);
  // Is the selected value in the available options?
  const isInvalid = (0, _react.useMemo)(() => !!value && !options.some(opt => opt.value === value), [value, options]);

  // If only one schema is available and it's not the preferred, show both in the dropdown
  const displayOptions = (0, _react.useMemo)(() => options.length === 1 && isInvalid ? [{
    inputDisplay: /*#__PURE__*/_react.default.createElement(InvalidDisplay, {
      value: getInputDisplay(value),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 190,
        columnNumber: 29
      }
    }),
    value: 'unknown',
    disabled: true,
    dropdownDisplay: /*#__PURE__*/_react.default.createElement(InvalidDropdownDisplay, {
      value: getInputDisplay(value),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 193,
        columnNumber: 32
      }
    })
  }, ...options] : options.length === 0 ? [{
    inputDisplay: _i18n.i18n.translate('xpack.infra.schemaSelector.noSchemaAvailable', {
      defaultMessage: 'No schema available'
    }),
    value: 'unknown'
  }] : options, [isInvalid, options, value]);
  const onSelect = (0, _react.useCallback)(selectedValue => {
    if (selectedValue !== 'unknown') {
      onChange(selectedValue);
      telemetry.reportSchemaSelectorInteraction({
        interaction: 'select schema',
        schema_selected: selectedValue,
        schemas_available: schemas
      });
    }
  }, [onChange, schemas, telemetry]);
  const handleSchemaSelectorClick = (0, _react.useCallback)(() => {
    telemetry.reportSchemaSelectorInteraction({
      interaction: 'open dropdown',
      schema_selected: value,
      schemas_available: schemas
    });
  }, [value, schemas, telemetry]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 233,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 0,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 234,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "aria-label": _i18n.i18n.translate('xpack.infra.schemaSelector.select.ariaLabel', {
      defaultMessage: 'Schema selector for data collection'
    }),
    css: {
      minWidth: isHostsView ? '400px' : '300px'
    },
    helpText: (options.length > 1 || options.length === 1 && isInvalid) && _i18n.i18n.translate('xpack.infra.schemaSelector.select.helpText', {
      defaultMessage: 'There are hosts available in another schema'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 235,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    onClickCapture: handleSchemaSelectorClick,
    "data-test-subj": "infraSchemaSelect",
    id: "infraSchemaSelectorSelect",
    options: displayOptions,
    compressed: true,
    valueOfSelected: isInvalid ? 'unknown' : value !== null && value !== void 0 ? value : 'semconv',
    onChange: onSelect,
    isLoading: isLoading,
    fullWidth: true,
    css: {
      fontSize: (0, _eui.useEuiFontSize)('xs').fontSize,
      fontWeight: euiTheme.font.weight.medium
    },
    prepend: /*#__PURE__*/_react.default.createElement(PrependLabel, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 261,
        columnNumber: 22
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 247,
      columnNumber: 11
    }
  }))));
};
exports.SchemaSelector = SchemaSelector;