"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Page = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _use_metrics_breadcrumbs = require("../../../hooks/use_metrics_breadcrumbs");
var _use_parent_breadcrumb_resolver = require("../../../hooks/use_parent_breadcrumb_resolver");
var _use_kibana = require("../../../hooks/use_kibana");
var _constants = require("../constants");
var _content = require("../content/content");
var _use_asset_details_render_props = require("../hooks/use_asset_details_render_props");
var _use_metadata_state = require("../hooks/use_metadata_state");
var _use_page_header = require("../hooks/use_page_header");
var _use_tab_switcher = require("../hooks/use_tab_switcher");
var _utils = require("../utils");
var _infra_page_template = require("../../shared/templates/infra_page_template");
var _no_data_config = require("../../shared/templates/no_data_config");
var _host_header_title = require("../header/host_header_title");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/components/asset_details/template/page.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const Page = ({
  tabs = [],
  links = []
}) => {
  const {
    metadata,
    loading: metadataLoading
  } = (0, _use_metadata_state.useMetadataStateContext)();
  const {
    rightSideItems,
    tabEntries,
    breadcrumbs: headerBreadcrumbs
  } = (0, _use_page_header.usePageHeader)(tabs, links);
  const {
    entity,
    loading,
    schema
  } = (0, _use_asset_details_render_props.useAssetDetailsRenderPropsContext)();
  const trackOnlyOnce = _react.default.useRef(false);
  const {
    activeTabId
  } = (0, _use_tab_switcher.useTabSwitcherContext)();
  const {
    services: {
      telemetry
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const parentBreadcrumbResolver = (0, _use_parent_breadcrumb_resolver.useParentBreadcrumbResolver)();
  const breadcrumbOptions = parentBreadcrumbResolver.getBreadcrumbOptions(entity.type);
  (0, _use_metrics_breadcrumbs.useMetricsBreadcrumbs)([{
    ...breadcrumbOptions.link,
    text: breadcrumbOptions.text
  }, {
    text: entity.name
  }, {
    text: (0, _lodash.capitalize)(activeTabId)
  }]);
  (0, _react.useEffect)(() => {
    if (trackOnlyOnce.current) {
      return;
    }
    if (!metadataLoading && metadata) {
      const integrations = (0, _utils.getIntegrationsAvailable)(metadata);
      const telemetryParams = {
        componentName: _constants.ASSET_DETAILS_PAGE_COMPONENT_NAME,
        assetType: entity.type,
        tabId: activeTabId,
        schema_selected: schema || 'ecs'
      };
      telemetry.reportAssetDetailsPageViewed(integrations.length > 0 ? {
        ...telemetryParams,
        integrations
      } : telemetryParams);
      trackOnlyOnce.current = true;
    }
  }, [activeTabId, entity.type, metadata, metadataLoading, telemetry, schema]);
  return /*#__PURE__*/_react.default.createElement(_infra_page_template.InfraPageTemplate, {
    onboardingFlow: entity.type === 'host' ? _no_data_config.OnboardingFlow.Hosts : _no_data_config.OnboardingFlow.Infra,
    dataSourceAvailability: entity.type === 'host' ? 'host' : undefined,
    pageHeader: {
      pageTitle: loading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
        size: "m",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 82,
          columnNumber: 11
        }
      }) : entity.type === 'host' ? /*#__PURE__*/_react.default.createElement(_host_header_title.HostHeaderTitle, {
        title: entity.name,
        schema: schema,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 84,
          columnNumber: 11
        }
      }) : entity.name,
      tabs: tabEntries,
      rightSideItems,
      breadcrumbs: headerBreadcrumbs
    },
    "data-component-name": _constants.ASSET_DETAILS_PAGE_COMPONENT_NAME,
    "data-asset-type": entity.type,
    "data-schema-selected": schema,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_content.Content, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 7
    }
  }));
};
exports.Page = Page;