"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProcessRowCharts = void 0;
var _charts = require("@elastic/charts");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _moment = _interopRequireDefault(require("moment"));
var _react = _interopRequireWildcard(require("react"));
var _chartIcons = require("@kbn/chart-icons");
var _public = require("@kbn/charts-plugin/public");
var _react2 = require("@emotion/react");
var _i18nReact = require("@kbn/i18n-react");
var _ioTsUtils = require("@kbn/io-ts-utils");
var _use_fetcher = require("../../../../hooks/use_fetcher");
var _calculate_domain = require("../../../../pages/metrics/metrics_explorer/components/helpers/calculate_domain");
var _use_timeline_chart_theme = require("../../../../hooks/use_timeline_chart_theme");
var _series_chart = require("../../../../pages/metrics/metrics_explorer/components/series_chart");
var _color_palette = require("../../../../../common/color_palette");
var _formatters = require("../../../../../common/formatters");
var _http_api = require("../../../../../common/http_api");
var _types = require("../../../../../common/metrics_explorer_views/types");
var _metric_not_available_explanation = require("../../components/metric_not_available_explanation");
var _use_process_list = require("../../hooks/use_process_list");
var _use_request_observable = require("../../hooks/use_request_observable");
var _use_tab_switcher = require("../../hooks/use_tab_switcher");
var _use_asset_details_render_props = require("../../hooks/use_asset_details_render_props");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/components/asset_details/tabs/processes/process_row_charts.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const EmptyChartPlaceholder = ({
  metricName
}) => /*#__PURE__*/_react.default.createElement(_public.EmptyPlaceholder, {
  css: (0, _react2.css)`
       {
        height: 140px;
      }
    `,
  icon: _chartIcons.IconChartLine,
  message: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    alignItems: "center",
    justifyContent: "center",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.metrics.nodeDetails.processes.charts.noDataLabel",
    defaultMessage: "No results found",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_metric_not_available_explanation.MetricNotAvailableExplanationTooltip, {
    metricName: metricName,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 11
    }
  }))),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 50,
    columnNumber: 3
  }
});
const ProcessRowCharts = ({
  command,
  hasCpuData,
  hasMemoryData
}) => {
  const {
    request$
  } = (0, _use_request_observable.useRequestObservable)();
  const {
    hostTerm,
    indexPattern,
    to
  } = (0, _use_process_list.useProcessListContext)();
  const {
    schema
  } = (0, _use_asset_details_render_props.useAssetDetailsRenderPropsContext)();
  const {
    isActiveTab
  } = (0, _use_tab_switcher.useTabSwitcherContext)();
  const {
    data,
    status,
    error
  } = (0, _use_fetcher.useFetcher)(async callApi => {
    const response = await callApi('/api/metrics/process_list/chart', {
      method: 'POST',
      body: JSON.stringify({
        hostTerm,
        indexPattern,
        to,
        command,
        schema
      })
    });
    return (0, _ioTsUtils.decodeOrThrow)(_http_api.ProcessListAPIChartResponseRT)(response);
  }, [command, hostTerm, indexPattern, to, schema], {
    requestObservable$: request$,
    autoFetch: isActiveTab('processes')
  });
  const isLoading = (0, _use_fetcher.isPending)(status) || !data;
  const cpuChart = error ? /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "warning",
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 104,
        columnNumber: 47
      }
    }, failedToLoadChart),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 5
    }
  }) : isLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingChart, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 5
    }
  }) : hasCpuData ? /*#__PURE__*/_react.default.createElement(ProcessChart, {
    timeseries: data.cpu,
    color: _color_palette.Color.color2,
    label: cpuMetricLabel,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 5
    }
  }) : /*#__PURE__*/_react.default.createElement(EmptyChartPlaceholder, {
    metricName: cpuMetricLabel,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 5
    }
  });
  const memoryChart = error ? /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "warning",
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 113,
        columnNumber: 47
      }
    }, failedToLoadChart),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 5
    }
  }) : isLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingChart, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 5
    }
  }) : hasMemoryData ? /*#__PURE__*/_react.default.createElement(ProcessChart, {
    timeseries: data.memory,
    color: _color_palette.Color.color0,
    label: memoryMetricLabel,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 5
    }
  }) : /*#__PURE__*/_react.default.createElement(EmptyChartPlaceholder, {
    metricName: memory,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 5
    }
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 9
    }
  }, cpuMetricLabel), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 9
    }
  }, cpuChart)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 9
    }
  }, memoryMetricLabel), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 9
    }
  }, memoryChart)));
};
exports.ProcessRowCharts = ProcessRowCharts;
const ProcessChart = ({
  timeseries,
  color,
  label
}) => {
  const chartTheme = (0, _use_timeline_chart_theme.useTimelineChartTheme)();
  const chartMetric = {
    color,
    aggregation: 'avg',
    label
  };
  const dateFormatter = (0, _react.useMemo)(() => {
    var _first, _last;
    if (!timeseries) return () => '';
    const firstTimestamp = (_first = (0, _lodash.first)(timeseries.rows)) === null || _first === void 0 ? void 0 : _first.timestamp;
    const lastTimestamp = (_last = (0, _lodash.last)(timeseries.rows)) === null || _last === void 0 ? void 0 : _last.timestamp;
    if (firstTimestamp == null || lastTimestamp == null) {
      return value => `${value}`;
    }
    return (0, _charts.niceTimeFormatter)([firstTimestamp, lastTimestamp]);
  }, [timeseries]);
  const yAxisFormatter = (0, _formatters.createFormatter)('percent');
  const dataDomain = (0, _calculate_domain.calculateDomain)(timeseries, [chartMetric], false);
  const domain = dataDomain ? {
    max: dataDomain.max * 1.1,
    // add 10% headroom.
    min: dataDomain.min
  } : {
    max: 0,
    min: 0
  };
  return /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    size: {
      height: '140px',
      width: '100%'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 172,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_series_chart.MetricExplorerSeriesChart, {
    type: _types.MetricsExplorerChartType.area,
    metric: chartMetric,
    id: "0",
    series: timeseries,
    stack: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 178,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: 'timestamp',
    position: _charts.Position.Bottom,
    showOverlappingTicks: true,
    tickFormat: dateFormatter,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: 'values',
    position: _charts.Position.Left,
    tickFormat: yAxisFormatter,
    domain: domain,
    ticks: 6,
    gridLine: {
      visible: true
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 191,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Tooltip, {
    headerFormatter: ({
      value
    }) => (0, _moment.default)(value).format('Y-MM-DD HH:mm:ss.SSS'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 199,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    baseTheme: chartTheme.baseTheme,
    theme: chartTheme.theme,
    locale: _i18n.i18n.getLocale(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 200,
      columnNumber: 7
    }
  }));
};
const cpuMetricLabel = _i18n.i18n.translate('xpack.infra.metrics.nodeDetails.processes.expandedRowLabelCPU', {
  defaultMessage: 'CPU'
});
const memoryMetricLabel = _i18n.i18n.translate('xpack.infra.metrics.nodeDetails.processes.expandedRowLabelMemory', {
  defaultMessage: 'Memory'
});
const memory = _i18n.i18n.translate('xpack.infra.metrics.nodeDetails.processes.expandedRowMemory', {
  defaultMessage: 'memory'
});
const failedToLoadChart = _i18n.i18n.translate('xpack.infra.metrics.nodeDetails.processes.failedToLoadChart', {
  defaultMessage: 'Unable to load chart'
});