"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CpuProfilingPrompt = CpuProfilingPrompt;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _use_profiling_integration_setting = require("../../../../../hooks/use_profiling_integration_setting");
var _use_tab_switcher = require("../../../hooks/use_tab_switcher");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/components/asset_details/tabs/overview/kpis/cpu_profiling_prompt.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function CpuProfilingPrompt() {
  const {
    showTab
  } = (0, _use_tab_switcher.useTabSwitcherContext)();
  const isProfilingPluginEnabled = (0, _use_profiling_integration_setting.useProfilingPluginSetting)();
  if (!isProfilingPluginEnabled) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "flexStart",
    gutterSize: "s",
    "data-test-subj": "infraAssetDetailsCPUProfilingPrompt",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 24,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "baseline",
    justifyContent: "flexStart",
    gutterSize: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 7
    }
  }, _i18n.i18n.translate('xpack.infra.cpuProfilingPrompt.promptText', {
    defaultMessage: 'View CPU Breakdown using'
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "infraCpuProfilingPromptProfilingButton",
    onClick: () => showTab('profiling'),
    flush: "both",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.infra.cpuProfilingPrompt.profilingLinkLabel', {
    defaultMessage: 'Profiling'
  }))));
}