"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertsSummaryContent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _common = require("@kbn/metrics-data-access-plugin/common");
var _reactHooks = require("@kbn/react-hooks");
var _plugin_config_context = require("../../../../../containers/plugin_config_context");
var _alert_flyout = require("../../../../../alerting/inventory/components/alert_flyout");
var _section_titles = require("../section_titles");
var _use_asset_details_render_props = require("../../../hooks/use_asset_details_render_props");
var _section = require("../../../components/section");
var _alerts_closed_content = require("./alerts_closed_content");
var _alerts_overview = require("../../../../shared/alerts/alerts_overview");
var _create_alert_rule_button = require("../../../../shared/alerts/links/create_alert_rule_button");
var _link_to_alerts_page = require("../../../../shared/alerts/links/link_to_alerts_page");
var _use_integration_check = require("../../../hooks/use_integration_check");
var _constants = require("../../../constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/components/asset_details/tabs/overview/alerts/alerts.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AlertsSummaryContent = ({
  entityId,
  entityType,
  dateRange
}) => {
  var _overrides$alertRule;
  const {
    featureFlags
  } = (0, _plugin_config_context.usePluginConfig)();
  const [isAlertFlyoutVisible, {
    toggle: toggleAlertFlyout
  }] = (0, _reactHooks.useBoolean)(false);
  const {
    overrides,
    schema
  } = (0, _use_asset_details_render_props.useAssetDetailsRenderPropsContext)();
  const [collapsibleStatus, setCollapsibleStatus] = (0, _react.useState)('open');
  const [activeAlertsCount, setActiveAlertsCount] = (0, _react.useState)(undefined);
  const onLoaded = alertsCount => {
    const {
      activeAlertCount = 0
    } = alertsCount !== null && alertsCount !== void 0 ? alertsCount : {};
    const hasActiveAlerts = activeAlertCount > 0;
    setCollapsibleStatus(hasActiveAlerts ? 'open' : 'closed');
    setActiveAlertsCount(alertsCount === null || alertsCount === void 0 ? void 0 : alertsCount.activeAlertCount);
  };
  const entityIdField = (0, _common.findInventoryFields)(entityType).id;
  const isDockerContainer = (0, _use_integration_check.useIntegrationCheck)({
    dependsOn: _constants.INTEGRATIONS.docker
  });
  const showCreateRuleFeature = featureFlags.inventoryThresholdAlertRuleEnabled && (entityType !== 'container' || isDockerContainer);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_section.Section, {
    title: /*#__PURE__*/_react.default.createElement(_section_titles.AlertsSectionTitle, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 60,
        columnNumber: 16
      }
    }),
    collapsible: true,
    "data-test-subj": "infraAssetDetailsAlertsCollapsible",
    id: "alerts",
    closedSectionContent: /*#__PURE__*/_react.default.createElement(_alerts_closed_content.AlertsClosedContent, {
      activeAlertCount: activeAlertsCount,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 64,
        columnNumber: 31
      }
    }),
    initialTriggerValue: collapsibleStatus,
    extraAction: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      responsive: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 67,
        columnNumber: 11
      }
    }, showCreateRuleFeature && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 69,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_create_alert_rule_button.CreateAlertRuleButton, {
      onClick: toggleAlertFlyout,
      "data-test-subj": "infraAssetDetailsAlertsTabCreateAlertsRuleButton",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 70,
        columnNumber: 17
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 76,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_link_to_alerts_page.LinkToAlertsPage, {
      kuery: `${entityIdField}:"${entityId}"`,
      dateRange: dateRange,
      "data-test-subj": "infraAssetDetailsAlertsTabAlertsShowAllButton",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 77,
        columnNumber: 15
      }
    }))),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_alerts_overview.AlertsOverview, {
    onLoaded: onLoaded,
    dateRange: dateRange,
    entityId: entityId,
    entityType: entityType,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 9
    }
  })), showCreateRuleFeature && /*#__PURE__*/_react.default.createElement(_alert_flyout.AlertFlyout, {
    filter: `${entityIdField}: "${entityId}"`,
    nodeType: entityType,
    schema: schema,
    setVisible: toggleAlertFlyout,
    visible: isAlertFlyoutVisible,
    options: overrides === null || overrides === void 0 ? void 0 : (_overrides$alertRule = overrides.alertRule) === null || _overrides$alertRule === void 0 ? void 0 : _overrides$alertRule.options,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 9
    }
  }));
};
exports.AlertsSummaryContent = AlertsSummaryContent;