"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DatePicker = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _use_date_picker = require("../hooks/use_date_picker");
var _popover = require("../tabs/common/popover");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/components/asset_details/date_picker/date_picker.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const COMMONLY_USED_RANGES = [{
  start: 'now-15m',
  end: 'now',
  label: _i18n.i18n.translate('xpack.infra.assetDetails.datePicker.commonlyUsedRanges.last15Minutes', {
    defaultMessage: 'Last 15 minutes'
  })
}, {
  start: 'now-1h',
  end: 'now',
  label: _i18n.i18n.translate('xpack.infra.assetDetails.datePicker.commonlyUsedRanges.last1Hour', {
    defaultMessage: 'Last 1 hour'
  })
}, {
  start: 'now-3h',
  end: 'now',
  label: _i18n.i18n.translate('xpack.infra.assetDetails.datePicker.commonlyUsedRanges.last3Hours', {
    defaultMessage: 'Last 3 hours'
  })
}, {
  start: 'now-24h',
  end: 'now',
  label: _i18n.i18n.translate('xpack.infra.assetDetails.datePicker.commonlyUsedRanges.last24Hours', {
    defaultMessage: 'Last 24 hours'
  })
}, {
  start: 'now-7d',
  end: 'now',
  label: _i18n.i18n.translate('xpack.infra.assetDetails.datePicker.commonlyUsedRanges.last7Days', {
    defaultMessage: 'Last 7 days'
  })
}];
const DatePicker = () => {
  const {
    dateRange,
    autoRefresh,
    setDateRange,
    setAutoRefresh,
    onRefresh
  } = (0, _use_date_picker.useDatePickerContext)();
  const handleRefresh = (0, _react.useCallback)(({
    start,
    end
  }) => {
    onRefresh({
      from: start,
      to: end
    });
  }, [onRefresh]);
  const handleTimeChange = (0, _react.useCallback)(({
    start,
    end,
    isInvalid
  }) => {
    if (!isInvalid) {
      setDateRange({
        from: start,
        to: end
      });
    }
  }, [setDateRange]);
  const handleAutoRefreshChange = (0, _react.useCallback)(({
    isPaused,
    refreshInterval
  }) => {
    setAutoRefresh({
      isPaused,
      interval: refreshInterval
    });
    if (!isPaused) {
      // when auto refresh is enabled, we need to force the end range to `now` in order for it to work automatically
      // otherwise,  users have to manually set `now` in the date picker
      setDateRange({
        from: dateRange.from,
        to: 'now'
      });
    }
  }, [dateRange.from, setAutoRefresh, setDateRange]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    responsive: false,
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(MemoEuiSuperDatePicker, {
    commonlyUsedRanges: COMMONLY_USED_RANGES,
    start: dateRange.from,
    end: dateRange.to,
    isPaused: autoRefresh === null || autoRefresh === void 0 ? void 0 : autoRefresh.isPaused,
    onTimeChange: handleTimeChange,
    onRefresh: handleRefresh,
    onRefreshChange: handleAutoRefreshChange,
    refreshInterval: autoRefresh === null || autoRefresh === void 0 ? void 0 : autoRefresh.interval,
    width: "full",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      minHeight: '18px'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 7
    }
  }, autoRefresh && !autoRefresh.isPaused && /*#__PURE__*/_react.default.createElement(AutoRefreshTroubleshootMessage, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 50
    }
  })));
};
exports.DatePicker = DatePicker;
const AutoRefreshTroubleshootMessage = () => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  gutterSize: "xs",
  alignItems: "baseline",
  responsive: false,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 123,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 124,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "xs",
  color: "subdued",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 125,
    columnNumber: 7
  }
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.infra.assetDetails.datePicker.tooltip.autoRefresh",
  defaultMessage: "Experiencing continually loading data?",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 126,
    columnNumber: 9
  }
}))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 132,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(_popover.Popover, {
  iconSize: "s",
  iconColor: "subdued",
  icon: "info",
  "data-test-subj": "infraAssetDetailsMetadataPopoverButton",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 133,
    columnNumber: 7
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "xs",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 139,
    columnNumber: 9
  }
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.infra.assetDetails.datePicker.tooltip.autoRefresh.troubleshoot",
  defaultMessage: "Try increasing the refresh interval, shortening the date range or turning off auto-refresh.",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 140,
    columnNumber: 11
  }
})))));

// Memo EuiSuperDatePicker to prevent re-renders from resetting the auto-refresh cycle
const MemoEuiSuperDatePicker = /*#__PURE__*/_react.default.memo(props => /*#__PURE__*/_react.default.createElement(_eui.EuiSuperDatePicker, (0, _extends2.default)({}, props, {
  updateButtonProps: {
    iconOnly: true
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 152,
    columnNumber: 3
  }
})));