"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExpandableContent = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _useToggle = _interopRequireDefault(require("react-use/lib/useToggle"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/components/asset_details/components/expandable_content.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ExpandableContent = props => {
  const {
    fieldName,
    values
  } = props;
  const [isExpanded, toggle] = (0, _useToggle.default)(false);
  const showLessRef = (0, _react.useRef)(null);
  const showMoreRef = (0, _react.useRef)(null);
  const list = Array.isArray(values) ? values : [values];
  const [first, ...others] = list;
  const hasOthers = others.length > 0;
  const shouldShowMore = hasOthers && !isExpanded;
  const hasInteracted = (0, _react.useRef)(false);
  const handleToggle = () => {
    hasInteracted.current = true;
    toggle();
  };
  (0, _react.useEffect)(() => {
    if (!hasInteracted.current) return;
    if (isExpanded) {
      var _showLessRef$current;
      (_showLessRef$current = showLessRef.current) === null || _showLessRef$current === void 0 ? void 0 : _showLessRef$current.focus();
    } else {
      var _showMoreRef$current;
      (_showMoreRef$current = showMoreRef.current) === null || _showMoreRef$current === void 0 ? void 0 : _showMoreRef$current.focus();
    }
  }, [isExpanded]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    responsive: false,
    alignItems: "baseline",
    wrap: true,
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: "eui-textTruncate",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 7
    }
  }, shouldShowMore && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "infraAssetDetailsExpandableContentCountMoreLink",
    "aria-label": _i18n.i18n.translate('xpack.infra.assetDetails.metadata.seeMore.ariaLabel', {
      defaultMessage: 'See {count} more {fieldName}',
      values: {
        fieldName,
        count: others.length
      }
    }),
    onClick: handleToggle,
    ref: showMoreRef,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.assetDetails.tabs.metadata.seeMore",
    defaultMessage: "+{count} more",
    values: {
      count: others.length
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 15
    }
  }))), hasOthers && isExpanded && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "infraExpandableContentShowLessLink",
    onClick: handleToggle,
    ref: showLessRef,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.infra.assetDetails.tabs.metadata.seeLess', {
    defaultMessage: 'Show less'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    delay: "long",
    content: first,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    className: "eui-textTruncate",
    tabIndex: 0,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 11
    }
  }, first))), isExpanded && others.map((item, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: index,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 50
    }
  }, item)));
};
exports.ExpandableContent = ExpandableContent;