"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRetryFilter = void 0;
var _inferenceCommon = require("@kbn/inference-common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const STATUS_NO_RETRY = [400,
// Bad Request
401,
// Unauthorized
402,
// Payment Required
403,
// Forbidden
404,
// Not Found
405,
// Method Not Allowed
406,
// Not Acceptable
407,
// Proxy Authentication Required
409 // Conflict
];
const retryAll = () => true;
const isRecoverable = err => {
  // tool validation error are from malformed json or generation not matching the schema
  if ((0, _inferenceCommon.isToolValidationError)(err)) {
    return true;
  }
  if ((0, _inferenceCommon.isInferenceRequestAbortedError)(err)) {
    return true;
  }
  if ((0, _inferenceCommon.isInferenceProviderError)(err)) {
    const status = err.status;
    if (status && STATUS_NO_RETRY.includes(status)) {
      return false;
    }
    return true;
  }
  return false;
};
const getRetryFilter = (retryOn = 'auto') => {
  if (typeof retryOn === 'function') {
    return retryOn;
  }
  if (retryOn === 'all') {
    return retryAll;
  }
  return isRecoverable;
};
exports.getRetryFilter = getRetryFilter;