"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndicesSelector = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _api = require("../../../../services/api");
var _shared_imports = require("../../../../../shared_imports");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/sections/enrich_policy_create/steps/fields/indices_selector.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const i18nTexts = {
  indices: {
    options: _i18n.i18n.translate('xpack.idxMgmt.enrichPolicyCreate.indicesSelector.optionsLabel', {
      defaultMessage: 'Based on your indices'
    }),
    noMatches: _i18n.i18n.translate('xpack.idxMgmt.enrichPolicyCreate.indicesSelector.noMatchingOption', {
      defaultMessage: 'No indices match your search criteria.'
    })
  },
  dataStreams: {
    options: _i18n.i18n.translate('xpack.idxMgmt.enrichPolicyCreate.indicesSelector.dataStream.optionsLabel', {
      defaultMessage: 'Based on your data streams'
    }),
    noMatches: _i18n.i18n.translate('xpack.idxMgmt.enrichPolicyCreate.indicesSelector.dataStream.noMatchingOption', {
      defaultMessage: 'No data streams match your search criteria.'
    })
  },
  sourcePlaceholder: _i18n.i18n.translate('xpack.idxMgmt.enrichPolicyCreate.indicesSelector.placeholder', {
    defaultMessage: 'Select source indices and data streams.'
  })
};
const getIndexOptions = async patternString => {
  if (!patternString) {
    return [];
  }
  const {
    data: indicesData
  } = await (0, _api.getMatchingIndices)(patternString);
  const {
    data: dataStreamsData
  } = await (0, _api.getMatchingDataStreams)(patternString);
  const indices = getMatchingOptions({
    matches: indicesData.indices,
    optionsMessage: i18nTexts.indices.options,
    noMatchingMessage: i18nTexts.indices.noMatches
  });
  const dataStreams = getMatchingOptions({
    matches: dataStreamsData.dataStreams,
    optionsMessage: i18nTexts.dataStreams.options,
    noMatchingMessage: i18nTexts.dataStreams.noMatches
  });
  return [...indices, ...dataStreams];
};
const getMatchingOptions = ({
  matches,
  optionsMessage,
  noMatchingMessage
}) => {
  const options = [];
  if (matches.length) {
    const matchingOptions = (0, _lodash.uniq)([...matches]);
    options.push({
      label: optionsMessage,
      options: matchingOptions.map(match => {
        return {
          label: match,
          value: match
        };
      }).sort((a, b) => String(a.label).localeCompare(b.label))
    });
  } else {
    options.push({
      label: noMatchingMessage,
      options: []
    });
  }
  return options;
};
const IndicesSelector = ({
  field,
  euiFieldProps,
  ...rest
}) => {
  const {
    isInvalid,
    errorMessage
  } = (0, _shared_imports.getFieldValidityAndErrorMessage)(field);
  const [indexOptions, setIndexOptions] = (0, _react.useState)([]);
  const [isIndiciesLoading, setIsIndiciesLoading] = (0, _react.useState)(false);
  const onSearchChange = (0, _react.useCallback)(async search => {
    const indexPattern = (0, _lodash.isEmpty)(search) ? '*' : search;
    setIsIndiciesLoading(true);
    setIndexOptions(await getIndexOptions(indexPattern));
    setIsIndiciesLoading(false);
  }, [setIsIndiciesLoading, setIndexOptions]);

  // Fetch indices on mount so that the ComboBox has some initial options
  (0, _react.useEffect)(() => {
    if ((0, _lodash.isEmpty)(field.value)) {
      onSearchChange('*');
    }
  }, [field.value, onSearchChange]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
    label: field.label,
    labelAppend: field.labelAppend,
    helpText: field.helpText,
    error: errorMessage,
    isInvalid: isInvalid,
    fullWidth: true
  }, rest, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, (0, _extends2.default)({
    isInvalid: isInvalid,
    async: true,
    placeholder: i18nTexts.sourcePlaceholder,
    isLoading: isIndiciesLoading,
    options: indexOptions,
    noSuggestions: !indexOptions.length,
    selectedOptions: (field.value || []).map(anIndex => {
      return {
        label: anIndex,
        value: anIndex
      };
    }),
    onChange: async selected => {
      field.setValue(selected.map(aSelected => aSelected.value));
    },
    onSearchChange: onSearchChange,
    onBlur: () => {
      if (!field.value) {
        field.setValue([]);
      }
    },
    "data-test-subj": "comboBox"
  }, euiFieldProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 7
    }
  })));
};
exports.IndicesSelector = IndicesSelector;