"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.configurationFormSchema = exports.ConfigurationStep = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../../shared_imports");
var _app_context = require("../../../app_context");
var _indices_selector = require("./fields/indices_selector");
var _documentation = require("../../../services/documentation");
var _create_policy_context = require("../create_policy_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/sections/enrich_policy_create/steps/configuration.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DISALLOWED_CHARS = ['"', ' ', '\\', '/', ',', '|', '>', '?', '*', '<'];
const configurationFormSchema = exports.configurationFormSchema = {
  name: {
    type: _shared_imports.FIELD_TYPES.TEXT,
    label: _i18n.i18n.translate('xpack.idxMgmt.enrichPolicyCreate.configurationStep.policyNameField', {
      defaultMessage: 'Policy name'
    }),
    validations: [{
      validator: _shared_imports.fieldValidators.emptyField(_i18n.i18n.translate('xpack.idxMgmt.enrichPolicyCreate.configurationStep.policyNameRequiredError', {
        defaultMessage: 'A policy name value is required.'
      }))
    }, {
      validator: _shared_imports.fieldValidators.containsCharsField({
        message: _i18n.i18n.translate('xpack.idxMgmt.enrichPolicyCreate.configurationStep.invalidCharactersInNameError', {
          defaultMessage: `Should not contain any of the following characters: {notAllowedChars}`,
          values: {
            notAllowedChars: DISALLOWED_CHARS.join(', ')
          }
        }),
        chars: DISALLOWED_CHARS
      })
    }]
  },
  type: {
    type: _shared_imports.FIELD_TYPES.SELECT,
    label: _i18n.i18n.translate('xpack.idxMgmt.enrichPolicyCreate.configurationStep.policyTypeLabel', {
      defaultMessage: 'Policy type'
    }),
    validations: [{
      validator: _shared_imports.fieldValidators.emptyField(_i18n.i18n.translate('xpack.idxMgmt.enrichPolicyCreate.configurationStep.typeRequiredError', {
        defaultMessage: 'A policy type value is required.'
      }))
    }]
  },
  sourceIndices: {
    label: _i18n.i18n.translate('xpack.idxMgmt.enrichPolicyCreate.configurationStep.sourceLabel', {
      defaultMessage: 'Source'
    }),
    validations: [{
      validator: _shared_imports.fieldValidators.emptyField(_i18n.i18n.translate('xpack.idxMgmt.enrichPolicyCreate.configurationStep.sourceRequiredError', {
        defaultMessage: 'At least one source is required.'
      }))
    }]
  },
  query: {
    type: _shared_imports.FIELD_TYPES.JSON,
    label: _i18n.i18n.translate('xpack.idxMgmt.enrichPolicyCreate.configurationStep.queryLabel', {
      defaultMessage: 'Query (optional)'
    }),
    serializer: jsonString => {
      let parsedJSON;
      try {
        parsedJSON = JSON.parse(jsonString);
      } catch {
        parsedJSON = {};
      }
      return parsedJSON;
    },
    deserializer: json => json && typeof json === 'object' ? JSON.stringify(json, null, 2) : '{\n\n}',
    validations: [{
      validator: _shared_imports.fieldValidators.isJsonField(_i18n.i18n.translate('xpack.idxMgmt.enrichPolicyCreate.configurationStep.queryInvalidError', {
        defaultMessage: 'The query is not valid JSON.'
      }), {
        allowEmptyString: true
      })
    }]
  }
};
const ConfigurationStep = ({
  onNext
}) => {
  const {
    core: {
      application: {
        getUrlForApp
      }
    }
  } = (0, _app_context.useAppContext)();
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const {
    draft,
    updateDraft,
    updateCompletionState
  } = (0, _create_policy_context.useCreatePolicyContext)();
  const {
    form
  } = (0, _shared_imports.useForm)({
    defaultValue: draft,
    schema: configurationFormSchema,
    id: 'configurationForm'
  });
  const onSubmit = async () => {
    const {
      isValid,
      data
    } = await form.submit();
    if (!isValid) {
      return;
    }

    // Update form completion state
    updateCompletionState(prevCompletionState => ({
      ...prevCompletionState,
      configurationStep: true
    }));

    // Update draft state with the data of the form
    updateDraft(prevDraft => ({
      ...prevDraft,
      ...((0, _lodash.isEmpty)(data.query) ? (0, _lodash.omit)(data, 'query') : data)
    }));

    // And then navigate to the next step
    onNext();
  };
  return /*#__PURE__*/_react.default.createElement(_shared_imports.Form, {
    form: form,
    "data-test-subj": "configurationForm",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 181,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "name",
    component: _shared_imports.TextField,
    componentProps: {
      fullWidth: false
    },
    "data-test-subj": "policyNameField",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "type",
    component: _shared_imports.SelectField,
    labelAppend: /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      button: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "typePopoverIcon",
        onClick: () => setIsPopoverOpen(isOpen => !isOpen),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 195,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "question",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 199,
          columnNumber: 17
        }
      })),
      isOpen: isPopoverOpen,
      closePopover: () => setIsPopoverOpen(false),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 193,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 205,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 206,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.enrichPolicyCreate.configurationStep.typeTitlePopOver",
      defaultMessage: "Determines how to match the data to incoming documents.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 207,
        columnNumber: 17
      }
    })), /*#__PURE__*/_react.default.createElement("ul", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 212,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement("li", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 213,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.enrichPolicyCreate.configurationStep.matchTypePopOver",
      defaultMessage: "{type} matches an exact value.",
      values: {
        type: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
          transparentBackground: true,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 217,
            columnNumber: 37
          }
        }, "Match")
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 214,
        columnNumber: 19
      }
    })), /*#__PURE__*/_react.default.createElement("li", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 220,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.enrichPolicyCreate.configurationStep.geoMatchTypePopOver",
      defaultMessage: "{type} matches a geographic location.",
      values: {
        type: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
          transparentBackground: true,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 224,
            columnNumber: 37
          }
        }, "Geo match")
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 221,
        columnNumber: 19
      }
    })), /*#__PURE__*/_react.default.createElement("li", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 227,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.enrichPolicyCreate.configurationStep.rangeTypePopOver",
      defaultMessage: "{type} matches a number, date, or IP address range.",
      values: {
        type: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
          transparentBackground: true,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 231,
            columnNumber: 37
          }
        }, "Range")
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 228,
        columnNumber: 19
      }
    }))))),
    componentProps: {
      fullWidth: false,
      euiFieldProps: {
        'data-test-subj': 'policyTypeField',
        options: [{
          value: 'match',
          text: _i18n.i18n.translate('xpack.idxMgmt.enrichPolicyCreate.configurationStep.matchOption', {
            defaultMessage: 'Match'
          })
        }, {
          value: 'geo_match',
          text: _i18n.i18n.translate('xpack.idxMgmt.enrichPolicyCreate.configurationStep.geoMatchOption', {
            defaultMessage: 'Geo match'
          })
        }, {
          value: 'range',
          text: _i18n.i18n.translate('xpack.idxMgmt.enrichPolicyCreate.configurationStep.rangeOption', {
            defaultMessage: 'Range'
          })
        }]
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 189,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "sourceIndices",
    component: _indices_selector.IndicesSelector,
    labelAppend: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 273,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      target: "_blank",
      "data-test-subj": "uploadFileLink",
      href: getUrlForApp('home', {
        path: '#/tutorial_directory/fileDataViz'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 274,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.enrichPolicyCreate.configurationStep.uploadFileLink",
      defaultMessage: "Upload a file",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 279,
        columnNumber: 15
      }
    }))),
    componentProps: {
      euiFieldProps: {
        'data-test-subj': 'policySourceIndicesField'
      },
      fullWidth: false
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 269,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "query",
    component: _shared_imports.JsonEditorField,
    componentProps: {
      fullWidth: false,
      helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.enrichPolicyCreate.configurationStep.queryHelpText",
        defaultMessage: "Defaults to: {code} query.",
        values: {
          code: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            external: true,
            target: "_blank",
            "data-test-subj": "matchAllQueryLink",
            href: _documentation.documentationService.getMatchAllQueryLink(),
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 305,
              columnNumber: 19
            }
          }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.idxMgmt.enrichPolicyCreate.configurationStep.matchAllLink",
            defaultMessage: "match_all",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 311,
              columnNumber: 21
            }
          }))
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 300,
          columnNumber: 13
        }
      }),
      codeEditorProps: {
        height: '300px',
        allowFullScreen: true,
        'aria-label': _i18n.i18n.translate('xpack.idxMgmt.enrichPolicyCreate.configurationStep.ariaLabelQuery', {
          defaultMessage: 'Query field data editor'
        }),
        options: {
          lineNumbers: 'off',
          tabSize: 2,
          automaticLayout: true
        }
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 294,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 338,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "configureStep",
    justifyContent: "spaceBetween",
    style: {
      maxWidth: 400
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 340,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 345,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 347,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    color: "primary",
    iconSide: "right",
    iconType: "arrowRight",
    disabled: form.isValid === false,
    "data-test-subj": "nextButton",
    onClick: onSubmit,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 348,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.enrichPolicyCreate.configurationStep.nextButtonLabel",
    defaultMessage: "Next",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 357,
      columnNumber: 13
    }
  })))));
};
exports.ConfigurationStep = ConfigurationStep;