"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isSelectedDataStreamHidden = exports.isManaged = exports.isDataStreamFullyManagedByILM = exports.isDataStreamFullyManagedByDSL = exports.isDSLWithILMIndices = exports.getLifecycleValue = exports.filterDataStreams = exports.deserializeGlobalMaxRetention = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _common = require("../../../common");
var _time_units = require("../constants/time_units");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/lib/data_streams.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const isManaged = dataStream => {
  var _dataStream$_meta;
  return Boolean((_dataStream$_meta = dataStream._meta) === null || _dataStream$_meta === void 0 ? void 0 : _dataStream$_meta.managed);
};
exports.isManaged = isManaged;
const filterDataStreams = (dataStreams, visibleTypes) => {
  return dataStreams.filter(dataStream => {
    // include all data streams that are neither hidden nor managed
    if (!dataStream.hidden && !isManaged(dataStream)) {
      return true;
    }
    if (dataStream.hidden && visibleTypes.includes('hidden')) {
      return true;
    }
    return isManaged(dataStream) && visibleTypes.includes('managed');
  });
};
exports.filterDataStreams = filterDataStreams;
const isSelectedDataStreamHidden = (dataStreams, selectedDataStreamName) => {
  var _dataStreams$find;
  return !!selectedDataStreamName && !!((_dataStreams$find = dataStreams.find(dataStream => dataStream.name === selectedDataStreamName)) !== null && _dataStreams$find !== void 0 && _dataStreams$find.hidden);
};
exports.isSelectedDataStreamHidden = isSelectedDataStreamHidden;
const getLifecycleValue = (lifecycle, inifniteAsIcon) => {
  var _match$text;
  if (!(lifecycle !== null && lifecycle !== void 0 && lifecycle.enabled)) {
    return _i18n.i18n.translate('xpack.idxMgmt.dataStreamList.dataRetentionDisabled', {
      defaultMessage: 'Disabled'
    });
  } else if (!(lifecycle !== null && lifecycle !== void 0 && lifecycle.effective_retention) && !(lifecycle !== null && lifecycle !== void 0 && lifecycle.data_retention)) {
    const infiniteDataRetention = _i18n.i18n.translate('xpack.idxMgmt.dataStreamList.dataRetentionInfinite', {
      defaultMessage: 'Keep data indefinitely'
    });
    if (inifniteAsIcon) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        "data-test-subj": "infiniteRetention",
        position: "top",
        content: infiniteDataRetention,
        type: "infinity",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 65,
          columnNumber: 9
        }
      });
    }
    return infiniteDataRetention;
  }

  // Extract size and unit, in order to correctly map the unit to the correct text
  const activeRetention = (lifecycle === null || lifecycle === void 0 ? void 0 : lifecycle.effective_retention) || (lifecycle === null || lifecycle === void 0 ? void 0 : lifecycle.data_retention);
  const {
    size,
    unit
  } = (0, _common.splitSizeAndUnits)(activeRetention);
  const availableTimeUnits = [..._time_units.timeUnits, ..._time_units.extraTimeUnits];
  const match = availableTimeUnits.find(timeUnit => timeUnit.value === unit);
  return `${size} ${(_match$text = match === null || match === void 0 ? void 0 : match.text) !== null && _match$text !== void 0 ? _match$text : unit}`;
};
exports.getLifecycleValue = getLifecycleValue;
const isDataStreamFullyManagedByILM = dataStream => {
  var _dataStream$nextGener, _dataStream$indices;
  return (dataStream === null || dataStream === void 0 ? void 0 : (_dataStream$nextGener = dataStream.nextGenerationManagedBy) === null || _dataStream$nextGener === void 0 ? void 0 : _dataStream$nextGener.toLowerCase()) === 'index lifecycle management' && (dataStream === null || dataStream === void 0 ? void 0 : (_dataStream$indices = dataStream.indices) === null || _dataStream$indices === void 0 ? void 0 : _dataStream$indices.every(index => {
    var _index$managedBy;
    return ((_index$managedBy = index.managedBy) === null || _index$managedBy === void 0 ? void 0 : _index$managedBy.toLowerCase()) === 'index lifecycle management';
  }));
};
exports.isDataStreamFullyManagedByILM = isDataStreamFullyManagedByILM;
const isDataStreamFullyManagedByDSL = dataStream => {
  var _dataStream$nextGener2, _dataStream$indices2;
  return (dataStream === null || dataStream === void 0 ? void 0 : (_dataStream$nextGener2 = dataStream.nextGenerationManagedBy) === null || _dataStream$nextGener2 === void 0 ? void 0 : _dataStream$nextGener2.toLowerCase()) === 'data stream lifecycle' && (dataStream === null || dataStream === void 0 ? void 0 : (_dataStream$indices2 = dataStream.indices) === null || _dataStream$indices2 === void 0 ? void 0 : _dataStream$indices2.every(index => {
    var _index$managedBy2;
    return ((_index$managedBy2 = index.managedBy) === null || _index$managedBy2 === void 0 ? void 0 : _index$managedBy2.toLowerCase()) === 'data stream lifecycle';
  }));
};
exports.isDataStreamFullyManagedByDSL = isDataStreamFullyManagedByDSL;
const isDSLWithILMIndices = dataStream => {
  var _dataStream$nextGener3;
  if ((dataStream === null || dataStream === void 0 ? void 0 : (_dataStream$nextGener3 = dataStream.nextGenerationManagedBy) === null || _dataStream$nextGener3 === void 0 ? void 0 : _dataStream$nextGener3.toLowerCase()) === 'data stream lifecycle') {
    var _dataStream$indices3, _dataStream$indices4;
    const ilmIndices = dataStream === null || dataStream === void 0 ? void 0 : (_dataStream$indices3 = dataStream.indices) === null || _dataStream$indices3 === void 0 ? void 0 : _dataStream$indices3.filter(index => {
      var _index$managedBy3;
      return ((_index$managedBy3 = index.managedBy) === null || _index$managedBy3 === void 0 ? void 0 : _index$managedBy3.toLowerCase()) === 'index lifecycle management';
    });
    const dslIndices = dataStream === null || dataStream === void 0 ? void 0 : (_dataStream$indices4 = dataStream.indices) === null || _dataStream$indices4 === void 0 ? void 0 : _dataStream$indices4.filter(index => {
      var _index$managedBy4;
      return ((_index$managedBy4 = index.managedBy) === null || _index$managedBy4 === void 0 ? void 0 : _index$managedBy4.toLowerCase()) === 'data stream lifecycle';
    });

    // When there aren't any ILM indices, there's no need to show anything.
    if (!(ilmIndices !== null && ilmIndices !== void 0 && ilmIndices.length)) {
      return;
    }
    return {
      ilmIndices,
      dslIndices
    };
  }
  return;
};
exports.isDSLWithILMIndices = isDSLWithILMIndices;
const deserializeGlobalMaxRetention = globalMaxRetention => {
  var _match$text2;
  if (!globalMaxRetention) {
    return {};
  }
  const {
    size,
    unit
  } = (0, _common.splitSizeAndUnits)(globalMaxRetention);
  const availableTimeUnits = [..._time_units.timeUnits, ..._time_units.extraTimeUnits];
  const match = availableTimeUnits.find(timeUnit => timeUnit.value === unit);
  return {
    size,
    unit,
    unitText: (_match$text2 = match === null || match === void 0 ? void 0 : match.text) !== null && _match$text2 !== void 0 ? _match$text2 : unit
  };
};
exports.deserializeGlobalMaxRetention = deserializeGlobalMaxRetention;