"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StepMappingsContainer = void 0;
var _react = _interopRequireDefault(require("react"));
var _shared_imports = require("../../../../../shared_imports");
var _services = require("../../../../services");
var _step_mappings = require("./step_mappings");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/components/shared/components/wizard_steps/step_mappings_container.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const StepMappingsContainer = ({
  esDocsBase,
  getTemplateData
}) => {
  const {
    defaultValue,
    updateContent,
    getSingleContentData
  } = _shared_imports.Forms.useContent('mappings');
  const {
    data: esNodesPlugins
  } = (0, _services.useLoadNodesPlugins)();
  const {
    getData
  } = _shared_imports.Forms.useMultiContentContext();
  let indexMode;
  if (getTemplateData) {
    const wizardContent = getData();
    // Build the current template object, providing the wizard content data
    const template = getTemplateData(wizardContent);
    indexMode = template === null || template === void 0 ? void 0 : template.indexMode;
  }
  return /*#__PURE__*/_react.default.createElement(_step_mappings.StepMappings, {
    defaultValue: defaultValue,
    onChange: updateContent,
    indexSettings: getSingleContentData('settings'),
    esDocsBase: esDocsBase,
    esNodesPlugins: esNodesPlugins !== null && esNodesPlugins !== void 0 ? esNodesPlugins : [],
    indexMode: indexMode,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 5
    }
  });
};
exports.StepMappingsContainer = StepMappingsContainer;