"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ComponentTemplateCreate = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _redirect_path = require("../../../../hooks/redirect_path");
var _breadcrumbs = require("../../../../services/breadcrumbs");
var _component_templates_context = require("../../component_templates_context");
var _use_update_associated_ds_mappings = require("../component_template_ds_mappings/use_update_associated_ds_mappings");
var _component_template_form = require("../component_template_form");
var _use_step_from_query_string = require("../use_step_from_query_string");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/components/component_templates/component_template_wizard/component_template_create/component_template_create.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ComponentTemplateCreate = ({
  history,
  sourceComponentTemplate
}) => {
  const [isSaving, setIsSaving] = (0, _react.useState)(false);
  const [saveError, setSaveError] = (0, _react.useState)(null);
  const redirectTo = (0, _redirect_path.useRedirectPath)(history);
  const [currentStep, setCurrentStep] = (0, _react.useState)('logistics');
  const [componentName, setComponentName] = (0, _react.useState)();
  const [canRollover, setCanRollover] = (0, _react.useState)(false);
  const {
    api
  } = (0, _component_templates_context.useComponentTemplatesContext)();
  const {
    activeStep: defaultActiveStep,
    updateStep
  } = (0, _use_step_from_query_string.useStepFromQueryString)(history);
  const locationSearchParams = (0, _react.useMemo)(() => {
    return new URLSearchParams(history.location.search);
  }, [history.location.search]);

  // Effect for computing if we should allow the user to rollover attached datastreams
  (0, _react.useEffect)(() => {
    async function computeCanRollover() {
      // When the current step is not logistics, we have an available component template
      // name that we can use to query the referenced index template.
      if (currentStep !== 'logistics') {
        // If the component template is referenced by an index template that is part of
        // a package and is managed we can allow the user to roll it over if possible.
        const {
          data: refIndexTemplate
        } = await api.getReferencedIndexTemplateMeta(componentName);
        setCanRollover(Boolean((refIndexTemplate === null || refIndexTemplate === void 0 ? void 0 : refIndexTemplate.managed_by) && (refIndexTemplate === null || refIndexTemplate === void 0 ? void 0 : refIndexTemplate.package)));
      }
      setCanRollover(false);
    }
    computeCanRollover();
  }, [api, currentStep, componentName, setCanRollover]);
  const defaultValue = (0, _react.useMemo)(() => {
    var _locationSearchParams;
    if (sourceComponentTemplate) {
      return sourceComponentTemplate;
    }
    const name = (_locationSearchParams = locationSearchParams.get('name')) !== null && _locationSearchParams !== void 0 ? _locationSearchParams : '';
    const managedBy = locationSearchParams.get('managed_by');
    return {
      name,
      template: {},
      _meta: managedBy ? {
        managed_by: managedBy
      } : {},
      _kbnMeta: {
        usedBy: [],
        isManaged: false
      }
    };
  }, [locationSearchParams, sourceComponentTemplate]);
  const {
    updateAssociatedDsMappings
  } = (0, _use_update_associated_ds_mappings.useUpdateAssociatedDsMappings)();
  const onSave = async componentTemplate => {
    const {
      name
    } = componentTemplate;
    setIsSaving(true);
    setSaveError(null);
    const {
      error
    } = await api.createComponentTemplate(componentTemplate);
    setIsSaving(false);
    if (error) {
      setSaveError(error);
      return;
    }

    // Update mappings from template for associated data streams for @custom templates or when
    // the component template is referenced by a managed package index template. Each data stream
    // updates its mappings from its index template. If updating fails, a modal prompts to rollover.
    if (componentTemplate.name.endsWith('@custom') || canRollover) {
      await updateAssociatedDsMappings(componentTemplate.name);
    }
    redirectTo(encodeURI(`/component_templates/${encodeURIComponent(name)}`));
  };
  const clearSaveError = () => {
    setSaveError(null);
  };
  const isCloning = Boolean(sourceComponentTemplate);
  (0, _react.useEffect)(() => {
    if (isCloning) {
      _breadcrumbs.breadcrumbService.setBreadcrumbs(_breadcrumbs.IndexManagementBreadcrumb.componentTemplateClone);
    } else {
      _breadcrumbs.breadcrumbService.setBreadcrumbs(_breadcrumbs.IndexManagementBreadcrumb.componentTemplateCreate);
    }
  }, [isCloning]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, {
    restrictWidth: true,
    style: {
      width: '100%'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
    pageTitle: /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "pageTitle",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 130,
        columnNumber: 11
      }
    }, isCloning ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.cloneComponentTemplate.pageTitle",
      defaultMessage: "Clone component template",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 132,
        columnNumber: 15
      }
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.createComponentTemplate.pageTitle",
      defaultMessage: "Create component template",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 137,
        columnNumber: 15
      }
    })),
    bottomBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_component_template_form.ComponentTemplateForm, {
    defaultActiveWizardSection: defaultActiveStep,
    onStepChange: step => {
      setCurrentStep(step);
      updateStep(step);
    },
    defaultValue: defaultValue,
    onSave: onSave,
    isSaving: isSaving,
    saveError: saveError,
    setComponentName: setComponentName,
    clearSaveError: clearSaveError,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 7
    }
  }));
};
exports.ComponentTemplateCreate = ComponentTemplateCreate;