"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddPolicyToTemplateConfirmModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _api = require("../../../services/api");
var _notification = require("../../../services/notification");
var _api_errors = require("../../../services/api_errors");
var _components = require("../../edit_policy/components");
var _shared_imports = require("../../../../shared_imports");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/index_lifecycle_management/public/application/sections/policy_list/components/add_policy_to_template_confirm_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AddPolicyToTemplateConfirmModal = ({
  policy,
  onSuccess,
  onCancel
}) => {
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const [isLegacy, setIsLegacy] = (0, _react.useState)(false);
  const [templateName, setTemplateName] = (0, _react.useState)('');
  const [aliasName, setAliasName] = (0, _react.useState)('');
  const [templateError, setTemplateError] = (0, _react.useState)('');
  const {
    error,
    isLoading,
    data: templates,
    resendRequest
  } = (0, _api.useLoadIndexTemplates)(isLegacy);
  const renderTemplateHasPolicyWarning = () => {
    var _selectedTemplate$set, _selectedTemplate$set2, _selectedTemplate$set3;
    const selectedTemplate = templates === null || templates === void 0 ? void 0 : templates.find(template => template.name === templateName);
    const existingPolicyName = selectedTemplate === null || selectedTemplate === void 0 ? void 0 : (_selectedTemplate$set = selectedTemplate.settings) === null || _selectedTemplate$set === void 0 ? void 0 : (_selectedTemplate$set2 = _selectedTemplate$set.index) === null || _selectedTemplate$set2 === void 0 ? void 0 : (_selectedTemplate$set3 = _selectedTemplate$set2.lifecycle) === null || _selectedTemplate$set3 === void 0 ? void 0 : _selectedTemplate$set3.name;
    if (!existingPolicyName) {
      return;
    }
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 60,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 61,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      style: {
        maxWidth: 400
      },
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.indexLifecycleMgmt.policyTable.addLifecyclePolicyToTemplateConfirmModal.templateHasPolicyWarningTitle",
        defaultMessage: "Template already has policy",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 65,
          columnNumber: 13
        }
      }),
      color: "warning",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 62,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.indexLifecycleMgmt.indexManagementTable.addLifecyclePolicyToTemplateConfirmModal.indexHasNoAliasesWarningMessage",
      defaultMessage: "This index template already has the policy {existingPolicyName} attached to it. Adding this policy will overwrite that configuration.",
      values: {
        existingPolicyName
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 72,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 81,
        columnNumber: 9
      }
    }));
  };
  const renderUnableToLoadTemplatesCallout = () => {
    const {
      statusCode = '',
      message = ''
    } = error;
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 89,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 90,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      style: {
        maxWidth: 400
      },
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.indexLifecycleMgmt.policyTable.addLifecyclePolicyToTemplateConfirmModal.errorLoadingTemplatesTitle",
        defaultMessage: "Unable to load index templates",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 94,
          columnNumber: 13
        }
      }),
      color: "danger",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 91,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 101,
        columnNumber: 11
      }
    }, message, " (", statusCode, ")"), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      isLoading: isLoading,
      color: "danger",
      onClick: resendRequest,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 104,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.indexLifecycleMgmt.indexManagementTable.addLifecyclePolicyToTemplateConfirmModal.errorLoadingTemplatesButton",
      defaultMessage: "Try again",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 105,
        columnNumber: 13
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 111,
        columnNumber: 9
      }
    }));
  };
  const renderAliasFormElement = () => {
    var _policy$policy$phases;
    const showAliasTextInput = (_policy$policy$phases = policy.policy.phases.hot) === null || _policy$policy$phases === void 0 ? void 0 : _policy$policy$phases.actions.rollover;
    if (!showAliasTextInput) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.indexLifecycleMgmt.policyTable.addLifecyclePolicyToTemplateConfirmModal.rolloverAliasLabel",
        defaultMessage: "Alias for rollover index",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 124,
          columnNumber: 11
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 122,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      value: aliasName,
      onChange: e => {
        setAliasName(e.target.value);
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 130,
        columnNumber: 9
      }
    }));
  };
  const renderForm = () => {
    let options = [];
    if (templates) {
      options = templates.map(({
        name
      }) => {
        return {
          label: name
        };
      });
    }
    const onComboChange = comboOptions => {
      setTemplateError('');
      setTemplateName(comboOptions.length > 0 ? comboOptions[0].label : '');
    };
    return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 154,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 155,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.indexLifecycleMgmt.policyTable.addLifecyclePolicyToTemplateConfirmModal.showLegacyTemplates",
        defaultMessage: "Show legacy index templates",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 158,
          columnNumber: 15
        }
      }),
      checked: isLegacy,
      onChange: e => {
        setTemplateName('');
        setIsLegacy(e.target.checked);
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 156,
        columnNumber: 11
      }
    })), error ? renderUnableToLoadTemplatesCallout() : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, renderTemplateHasPolicyWarning(), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      isInvalid: !!templateError,
      error: templateError,
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.indexLifecycleMgmt.policyTable.addLifecyclePolicyToTemplateConfirmModal.chooseTemplateLabel",
        defaultMessage: "Index template",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 179,
          columnNumber: 17
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 175,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
      isInvalid: !!templateError,
      isLoading: isLoading,
      placeholder: _i18n.i18n.translate('xpack.indexLifecycleMgmt.policyTable.addLifecyclePolicyToTemplateConfirmModal.chooseTemplateMessage', {
        defaultMessage: 'Select an index template'
      }),
      options: options,
      selectedOptions: templateName ? [{
        label: templateName
      }] : [],
      onChange: onComboChange,
      singleSelection: {
        asPlainText: true
      },
      isClearable: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 185,
        columnNumber: 15
      }
    }))), renderAliasFormElement());
  };
  const addPolicyToTemplate = async () => {
    const policyName = policy.name;
    if (!templateName) {
      setTemplateError(_i18n.i18n.translate('xpack.indexLifecycleMgmt.policyTable.addLifecyclePolicyToTemplateConfirmModal.noTemplateSelectedErrorMessage', {
        defaultMessage: 'You must select an index template.'
      }));
      return;
    }
    try {
      await (0, _api.addLifecyclePolicyToTemplate)({
        policyName,
        templateName,
        aliasName: aliasName === '' ? undefined : aliasName
      }, isLegacy);
      const message = _i18n.i18n.translate('xpack.indexLifecycleMgmt.policyTable.addLifecyclePolicyToTemplateConfirmModal.successMessage', {
        defaultMessage: 'Added policy {policyName} to index template {templateName}',
        values: {
          policyName,
          templateName
        }
      });
      _notification.toasts.addSuccess(message);
      onSuccess(templateName);
    } catch (e) {
      const title = _i18n.i18n.translate('xpack.indexLifecycleMgmt.policyTable.addLifecyclePolicyToTemplateConfirmModal.errorMessage', {
        defaultMessage: 'Error adding policy "{policyName}" to index template {templateName}',
        values: {
          policyName,
          templateName
        }
      });
      (0, _api_errors.showApiError)(e, title);
    }
  };
  const title = _i18n.i18n.translate('xpack.indexLifecycleMgmt.policyTable.addLifecyclePolicyToTemplateConfirmModal.title', {
    defaultMessage: 'Add policy "{name}" to index template',
    values: {
      name: policy.name
    }
  });
  const {
    docLinks
  } = (0, _shared_imports.useKibana)().services;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "data-test-subj": "addPolicyToTemplateModal",
    title: title,
    "aria-labelledby": modalTitleId,
    titleProps: {
      id: modalTitleId
    },
    onCancel: onCancel,
    onConfirm: addPolicyToTemplate,
    cancelButtonText: _i18n.i18n.translate('xpack.indexLifecycleMgmt.policyTable.addLifecyclePolicyToTemplateConfirmModal.cancelButton', {
      defaultMessage: 'Cancel'
    }),
    confirmButtonText: _i18n.i18n.translate('xpack.indexLifecycleMgmt.policyTable.addLifecyclePolicyToTemplateConfirmModal.confirmButton', {
      defaultMessage: 'Add policy'
    }),
    confirmButtonDisabled: isLoading || !!error || !templates,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 268,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 289,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 290,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.indexLifecycleMgmt.policyTable.addLifecyclePolicyToTemplateConfirmModal.explanationText",
    defaultMessage: "This will apply the lifecycle policy to all indices which match the index template.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 291,
      columnNumber: 11
    }
  }), ' ', /*#__PURE__*/_react.default.createElement(_components.LearnMoreLink, {
    docPath: docLinks.links.elasticsearch.indexTemplates,
    text: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.indexLifecycleMgmt.editPolicy.learnAboutIndexTemplatesLink",
      defaultMessage: "Learn about index templates",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 299,
        columnNumber: 15
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 296,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 307,
      columnNumber: 7
    }
  }), renderForm());
};
exports.AddPolicyToTemplateConfirmModal = AddPolicyToTemplateConfirmModal;