"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RepositoryComboBoxField = void 0;
var _react = _interopRequireWildcard(require("react"));
var _shared_imports = require("../../../../../../../shared_imports");
var _form = require("../../../../form");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/index_lifecycle_management/public/application/sections/edit_policy/components/phases/shared_fields/searchable_snapshot_field/repository_combobox_field.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const RepositoryComboBoxField = ({
  field,
  isLoading,
  repos,
  noSuggestions,
  globalRepository
}) => {
  const isMounted = (0, _react.useRef)(false);
  const {
    setValue
  } = field;
  const {
    searchableSnapshotRepo: {
      setValue: setSearchableSnapshotRepository
    }
  } = (0, _form.useGlobalFields)();
  (0, _react.useEffect)(() => {
    // We keep our phase searchable action field in sync
    // with the default repository field declared globally for the policy
    if (isMounted.current) {
      setValue(Boolean(globalRepository.trim()) ? [globalRepository] : []);
    }
    isMounted.current = true;
  }, [setValue, globalRepository]);
  return /*#__PURE__*/_react.default.createElement(_shared_imports.ComboBoxField, {
    field: field,
    fullWidth: false,
    euiFieldProps: {
      'data-test-subj': 'searchableSnapshotCombobox',
      options: repos.map(repo => ({
        label: repo,
        value: repo
      })),
      singleSelection: {
        asPlainText: true
      },
      isLoading,
      noSuggestions,
      onCreateOption: newOption => {
        setSearchableSnapshotRepository(newOption);
      },
      onChange: options => {
        if (options.length > 0) {
          setSearchableSnapshotRepository(options[0].label);
        } else {
          setSearchableSnapshotRepository('');
        }
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 5
    }
  });
};
exports.RepositoryComboBoxField = RepositoryComboBoxField;