"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ColdPhase = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _form = require("../../../form");
var _shared_fields = require("../shared_fields");
var _phase = require("../phase");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/index_lifecycle_management/public/application/sections/edit_policy/components/phases/cold_phase/cold_phase.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const i18nTexts = {
  dataTierAllocation: {
    description: _i18n.i18n.translate('xpack.indexLifecycleMgmt.coldPhase.dataTier.description', {
      defaultMessage: 'Move data to nodes optimized for less frequent, read-only access. Store data in the cold phase on less-expensive hardware.'
    })
  }
};
const ColdPhase = () => {
  const {
    isUsingSearchableSnapshotInHotPhase,
    isUsingDownsampleInHotPhase,
    isUsingDownsampleInWarmPhase,
    isUsingDownsampleInColdPhase
  } = (0, _form.useConfiguration)();
  return /*#__PURE__*/_react.default.createElement(_phase.Phase, {
    phase: "cold",
    topLevelSettings: /*#__PURE__*/_react.default.createElement(_shared_fields.SearchableSnapshotField, {
      phase: "cold",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 42,
        columnNumber: 43
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_shared_fields.ReplicasField, {
    phase: "cold",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 7
    }
  }), !isUsingSearchableSnapshotInHotPhase && /*#__PURE__*/_react.default.createElement(_shared_fields.DownsampleField, {
    phase: "cold",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 48
    }
  }), !isUsingSearchableSnapshotInHotPhase && !isUsingDownsampleInHotPhase && !isUsingDownsampleInWarmPhase && !isUsingDownsampleInColdPhase && /*#__PURE__*/_react.default.createElement(_shared_fields.ReadonlyField, {
    phase: "cold",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 42
    }
  }), /*#__PURE__*/_react.default.createElement(_shared_fields.DataTierAllocationField, {
    description: i18nTexts.dataTierAllocation.description,
    phase: "cold",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_shared_fields.IndexPriorityField, {
    phase: "cold",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 7
    }
  }));
};
exports.ColdPhase = ColdPhase;