"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.migratePackagePolicyToV880 = void 0;
var _security_solution = require("./security_solution");
var _synthetics = require("./synthetics");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const migratePackagePolicyToV880 = (packagePolicyDoc, migrationContext) => {
  var _packagePolicyDoc$att, _packagePolicyDoc$att2;
  let updatedPackagePolicyDoc = packagePolicyDoc;

  // Endpoint specific migrations
  if (((_packagePolicyDoc$att = packagePolicyDoc.attributes.package) === null || _packagePolicyDoc$att === void 0 ? void 0 : _packagePolicyDoc$att.name) === 'endpoint') {
    updatedPackagePolicyDoc = (0, _security_solution.migratePackagePolicyToV880)(packagePolicyDoc, migrationContext);
  }

  // Synthetics specific migrations
  if (((_packagePolicyDoc$att2 = packagePolicyDoc.attributes.package) === null || _packagePolicyDoc$att2 === void 0 ? void 0 : _packagePolicyDoc$att2.name) === 'synthetics') {
    updatedPackagePolicyDoc = (0, _synthetics.migratePackagePolicyToV880)(packagePolicyDoc, migrationContext);
  }
  return updatedPackagePolicyDoc;
};
exports.migratePackagePolicyToV880 = migratePackagePolicyToV880;