"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CustomLogsAssetsExtension = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/logs-shared-plugin/common");
var _custom_assets_accordion = require("./components/custom_assets_accordion");
var _hooks = require("./hooks");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/custom_logs_assets_extension.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const CustomLogsAssetsExtension = () => {
  const {
    share: {
      url
    }
  } = (0, _hooks.useStartServices)();
  const logsLocator = (0, _common.getLogsLocatorFromUrlService)(url);
  const views = [{
    name: _i18n.i18n.translate('xpack.fleet.assets.customLogs.name', {
      defaultMessage: 'Logs'
    }),
    url: logsLocator.getRedirectUrl({}),
    description: _i18n.i18n.translate('xpack.fleet.assets.customLogs.description', {
      defaultMessage: 'View custom logs data in Discover'
    })
  }];
  return /*#__PURE__*/_react.default.createElement(_custom_assets_accordion.CustomAssetsAccordion, {
    views: views,
    initialIsOpen: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 10
    }
  });
};
exports.CustomLogsAssetsExtension = CustomLogsAssetsExtension;