"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InlineReleaseBadge = exports.HeaderReleaseBadge = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/components/release_badge.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const RELEASE_BADGE_LABEL = {
  beta: _i18n.i18n.translate('xpack.fleet.epm.releaseBadge.betaLabel', {
    defaultMessage: 'Beta'
  }),
  preview: _i18n.i18n.translate('xpack.fleet.epm.releaseBadge.technicalPreviewLabel', {
    defaultMessage: 'Technical preview'
  }),
  rc: _i18n.i18n.translate('xpack.fleet.epm.releaseBadge.releaseCandidateLabel', {
    defaultMessage: 'Release Candidate'
  })
};
const RELEASE_BADGE_DESCRIPTION = {
  beta: _i18n.i18n.translate('xpack.fleet.epm.releaseBadge.betaDescription', {
    defaultMessage: 'This integration is not recommended for use in production environments.'
  }),
  preview: _i18n.i18n.translate('xpack.fleet.epm.releaseBadge.technicalPreviewDescription', {
    defaultMessage: 'This functionality is in technical preview and may be changed or removed completely in a future release. Elastic will work to fix any issues, but features in technical preview are not subject to the support SLA of official GA features.'
  }),
  rc: _i18n.i18n.translate('xpack.fleet.epm.releaseBadge.releaseCandidateDescription', {
    defaultMessage: 'This integration is not recommended for use in production environments.'
  })
};
const HeaderReleaseBadge = ({
  release
}) => {
  if (release === 'ga') return null;
  const releaseLabel = RELEASE_BADGE_LABEL[release];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "bottom",
    content: RELEASE_BADGE_DESCRIPTION[release],
    title: releaseLabel,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    tabIndex: 0,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 7
    }
  }, releaseLabel));
};
exports.HeaderReleaseBadge = HeaderReleaseBadge;
const InlineReleaseBadge = ({
  release
}) => {
  if (release === 'ga') return null;
  const releaseLabel = RELEASE_BADGE_LABEL[release];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    display: "inlineBlock",
    content: RELEASE_BADGE_DESCRIPTION[release],
    title: releaseLabel,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow",
    tabIndex: 0,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 7
    }
  }, releaseLabel));
};
exports.InlineReleaseBadge = InlineReleaseBadge;