"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InstallButton = InstallButton;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _types = require("../../../../../types");
var _hooks = require("../../../../../hooks");
var _transform_install_as_current_user_callout = require("../../../../../../../components/transform_install_as_current_user_callout");
var _confirm_package_install = require("./confirm_package_install");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/integrations/sections/epm/screens/detail/settings/install_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function InstallButton(props) {
  const {
    name,
    title,
    version,
    assets
  } = props;
  const canInstallPackages = (0, _hooks.useAuthz)().integrations.installPackages;
  const installPackage = (0, _hooks.useInstallPackage)();
  const getPackageInstallStatus = (0, _hooks.useGetPackageInstallStatus)();
  const {
    status: installationStatus
  } = getPackageInstallStatus(name);
  const numOfAssets = Object.entries(assets).reduce((acc, [serviceName, serviceNameValue]) => acc + Object.entries(serviceNameValue || {}).reduce((acc2, [assetName, assetNameValue]) => acc2 + assetNameValue.length, 0), 0);
  const numOfTransformAssets = (0, _transform_install_as_current_user_callout.getNumTransformAssets)(assets);
  const isInstalling = installationStatus === _types.InstallStatus.installing;
  const [isInstallModalVisible, setIsInstallModalVisible] = (0, _react.useState)(false);
  const toggleInstallModal = (0, _react.useCallback)(() => {
    setIsInstallModalVisible(!isInstallModalVisible);
  }, [isInstallModalVisible]);
  const handleClickInstall = (0, _react.useCallback)(() => {
    installPackage({
      name,
      version,
      title
    });
    toggleInstallModal();
  }, [installPackage, name, title, toggleInstallModal, version]);
  const installModal = /*#__PURE__*/_react.default.createElement(_confirm_package_install.ConfirmPackageInstall, {
    numOfAssets: numOfAssets,
    numOfTransformAssets: numOfTransformAssets,
    packageName: title,
    onCancel: toggleInstallModal,
    onConfirm: handleClickInstall,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 5
    }
  });
  return canInstallPackages ? /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    iconType: 'importAction',
    isLoading: isInstalling,
    onClick: toggleInstallModal,
    "data-test-subj": "installAssetsButton",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 7
    }
  }, isInstalling ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.integrations.installPackage.installingPackageButtonLabel",
    defaultMessage: "Installing {title}",
    values: {
      title
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 11
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.integrations.installPackage.installPackageButtonLabel",
    defaultMessage: "Install {title}",
    values: {
      title
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 11
    }
  })), isInstallModalVisible && installModal) : null;
}