"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BidirectionalIntegrationsBanner = void 0;
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/integrations/sections/epm/screens/detail/components/bidirectional_integrations_callout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * A list of Integration `package.name`'s that support security's bi-directional response actions
 * along with its corresponding storage (local storage) key for persisting the user's dismissal of
 * the callout
 */
const SUPPORTED_INTEGRATIONS_STORAGE_KEY = Object.freeze({
  sentinel_one: 'fleet.showSOReponseSupportBanner',
  crowdstrike: 'fleet.showCSResponseSupportBanner',
  microsoft_defender_endpoint: 'fleet.showMSDefenderResponseSupportBanner',
  m365_defender: 'fleet.showMSDefenderResponseSupportBanner' // Same key as the one above
});
const AccentCallout = (0, _styledComponents.default)(_eui.EuiCallOut)`
  .euiCallOutHeader__title {
    color: ${props => props.theme.eui.euiColorAccent};
  }
  background-color: ${props => props.theme.eui.euiPanelBackgroundColorModifiers.accent};
`;
const BidirectionalIntegrationsBanner = exports.BidirectionalIntegrationsBanner = /*#__PURE__*/(0, _react.memo)(({
  integrationPackageName
}) => {
  var _storage$get;
  const {
    docLinks,
    storage
  } = (0, _public.useKibana)().services;
  const storageKey = SUPPORTED_INTEGRATIONS_STORAGE_KEY[integrationPackageName];
  const [showBanner, setShowBanner] = (0, _react.useState)(storageKey ? (_storage$get = storage.get(storageKey)) !== null && _storage$get !== void 0 ? _storage$get : true : false);
  const onDismissHandler = (0, _react.useCallback)(() => {
    setShowBanner(false);
    if (storageKey) {
      storage.set(storageKey, false);
    }
  }, [storage, storageKey]);
  const bannerTitle = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "accent",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.bidirectionalIntegrationsBanner.title",
    defaultMessage: 'NEW: Response enabled integration',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 11
    }
  })), []);
  if (!storageKey || !showBanner) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(AccentCallout, {
    title: bannerTitle,
    iconType: "cheer",
    onDismiss: onDismissHandler,
    "data-test-subj": 'bidirectionalIntegrationsCallout',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.bidirectionalIntegrationsBanner.body",
    defaultMessage: "Orchestrate response actions across endpoint vendors with bidirectional integrations. {learnmore}.",
    values: {
      learnmore: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: docLinks === null || docLinks === void 0 ? void 0 : docLinks.links.securitySolution.bidirectionalIntegrations,
        target: "_blank",
        "data-test-subj": "bidirectionalIntegrationDocLink",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 83,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.bidirectionalIntegrations.doc.link",
        defaultMessage: "Learn more",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 88,
          columnNumber: 19
        }
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 9
    }
  }));
});
BidirectionalIntegrationsBanner.displayName = 'BidirectionalIntegrationsBanner';