"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InstallKibanaAssetsButton = InstallKibanaAssetsButton;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _hooks = require("../../../../../hooks");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/integrations/sections/epm/screens/detail/assets/install_kibana_assets_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function InstallKibanaAssetsButton({
  installInfo,
  title,
  onSuccess
}) {
  const {
    notifications
  } = (0, _hooks.useStartServices)();
  const {
    name,
    version
  } = installInfo;
  const canInstallPackages = (0, _hooks.useAuthz)().integrations.installPackages;
  const {
    mutateAsync,
    isLoading
  } = (0, _hooks.useInstallKibanaAssetsMutation)();
  const handleClickInstall = (0, _react.useCallback)(async () => {
    try {
      await mutateAsync({
        pkgName: name,
        pkgVersion: version
      });
      if (onSuccess) {
        await onSuccess();
      }
    } catch (err) {
      notifications.toasts.addError(err, {
        title: _i18n.i18n.translate('xpack.fleet.fleetServerSetup.kibanaInstallAssetsErrorTitle', {
          defaultMessage: 'Error installing Kibana assets'
        })
      });
    }
  }, [mutateAsync, onSuccess, name, version, notifications.toasts]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    disabled: !canInstallPackages,
    iconType: "importAction",
    isLoading: isLoading,
    onClick: handleClickInstall,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.integrations.installPackage.kibanaAssetsInstallingButtonLabel",
    defaultMessage: "{isLoading, select, true {Installing} other {Install}} Kibana assets in current space",
    values: {
      isLoading
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 7
    }
  }));
}