"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IntegrationsAppContext = exports.AppRoutes = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _eui = require("@elastic/eui");
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _reactQuery = require("@kbn/react-query");
var _reactQueryDevtools = require("@tanstack/react-query-devtools");
var _common = require("@kbn/kibana-react-plugin/common");
var _public = require("@kbn/kibana-react-plugin/public");
var _reactKibanaContextRender = require("@kbn/react-kibana-context-render");
var _sharedUxLinkRedirectApp = require("@kbn/shared-ux-link-redirect-app");
var _hooks = require("../../hooks");
var _use_space_settings_context = require("../../hooks/use_space_settings_context");
var _components = require("../fleet/components");
var _error = require("../../layouts/error");
var _hooks2 = require("./hooks");
var _constants = require("./constants");
var _epm = require("./sections/epm");
var _header = require("./components/header");
var _components2 = require("./components");
var _use_read_only_context = require("./hooks/use_read_only_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/integrations/app.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const queryClient = new _reactQuery.QueryClient({
  defaultOptions: {
    queries: {
      networkMode: 'always'
    },
    mutations: {
      networkMode: 'always'
    }
  }
});
const EmptyContext = () => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);

/**
 * Fleet Application context all the way down to the Router, but with no permissions or setup checks
 * and no routes defined
 */
const IntegrationsAppContext = exports.IntegrationsAppContext = /*#__PURE__*/(0, _react.memo)(({
  children,
  startServices,
  config,
  history,
  kibanaVersion,
  extensions,
  setHeaderActionMenu,
  fleetStatus
}) => {
  var _startServices$cloud;
  const XXL_BREAKPOINT = 1600;
  const isDarkMode = (0, _useObservable.default)(startServices.theme.theme$, startServices.theme.getTheme()).darkMode;
  const CloudContext = ((_startServices$cloud = startServices.cloud) === null || _startServices$cloud === void 0 ? void 0 : _startServices$cloud.CloudContextProvider) || EmptyContext;
  return /*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, (0, _extends2.default)({}, startServices, {
    theme: startServices.theme,
    modify: {
      breakpoint: {
        xxl: XXL_BREAKPOINT
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_sharedUxLinkRedirectApp.RedirectAppLinks, {
    coreStart: {
      application: startServices.application
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
    services: {
      ...startServices
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_hooks.ConfigContext.Provider, {
    value: config,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_hooks.KibanaVersionContext.Provider, {
    value: kibanaVersion,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_common.EuiThemeProvider, {
    darkMode: isDarkMode,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_reactQuery.QueryClientProvider, {
    client: queryClient,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_reactQueryDevtools.ReactQueryDevtools, {
    initialIsOpen: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 21
    }
  }), /*#__PURE__*/_react.default.createElement(_hooks2.UIExtensionsContext.Provider, {
    value: extensions,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_hooks.FleetStatusProvider, {
    defaultFleetStatus: fleetStatus,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(_use_space_settings_context.SpaceSettingsContextProvider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 25
    }
  }, /*#__PURE__*/_react.default.createElement(startServices.customIntegrations.ContextProvider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 27
    }
  }, /*#__PURE__*/_react.default.createElement(CloudContext, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 29
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Router, {
    history: history,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 31
    }
  }, /*#__PURE__*/_react.default.createElement(_use_read_only_context.ReadOnlyContextProvider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 33
    }
  }, /*#__PURE__*/_react.default.createElement(_hooks2.AgentPolicyContextProvider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 35
    }
  }, /*#__PURE__*/_react.default.createElement(_hooks2.PackageInstallProvider, {
    startServices: startServices,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 37
    }
  }, /*#__PURE__*/_react.default.createElement(_hooks2.FlyoutContextProvider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 39
    }
  }, /*#__PURE__*/_react.default.createElement(_header.IntegrationsHeader, {
    setHeaderActionMenu,
    startServices,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 41
    }
  }), children)))))))))))))))));
});
const AppRoutes = exports.AppRoutes = /*#__PURE__*/(0, _react.memo)(() => {
  var _fleetStatus$missingR;
  const flyoutContext = (0, _hooks2.useFlyoutContext)();
  const fleetStatus = (0, _hooks.useFleetStatus)();
  const authz = (0, _hooks.useAuthz)();
  const isAddIntegrationsPath = !!(0, _reactRouterDom.useRouteMatch)(_constants.FLEET_ROUTING_PATHS.add_integration_to_policy);
  const allowedToAccess = authz.integrations.readIntegrationPolicies || authz.integrations.all || authz.fleet.all;
  const missingPrivilegesString = 'MISSING_PRIVILEGES';
  if (!allowedToAccess) {
    return /*#__PURE__*/_react.default.createElement(_error.ErrorLayout, {
      isAddIntegrationsPath: isAddIntegrationsPath,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 166,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_error.PermissionsError, {
      callingApplication: "Integrations",
      error: missingPrivilegesString,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 167,
        columnNumber: 9
      }
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 174,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants.INTEGRATIONS_ROUTING_PATHS.integrations,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_epm.EPMApp, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    render: ({
      location
    }) => {
      // BWC < 7.15 Fleet was using a hash router: redirect old routes using hash
      const shouldRedirectHash = location.pathname === '' && location.hash.length > 0;
      if (!shouldRedirectHash) {
        return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
          to: _constants.pagePathGetters.integrations_all({})[1],
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 183,
            columnNumber: 22
          }
        });
      }
      const pathname = location.hash.replace(/^#/, '');
      return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
        to: {
          ...location,
          pathname,
          hash: undefined
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 188,
          columnNumber: 15
        }
      });
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 178,
      columnNumber: 9
    }
  })), flyoutContext.isEnrollmentFlyoutOpen && /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 200,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_components2.AgentEnrollmentFlyout, {
    defaultMode: fleetStatus.isReady && (_fleetStatus$missingR = fleetStatus.missingRequirements) !== null && _fleetStatus$missingR !== void 0 && _fleetStatus$missingR.includes('fleet_server') ? 'managed' : 'standalone',
    isIntegrationFlow: true,
    onClose: () => flyoutContext.closeEnrollmentFlyout(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 201,
      columnNumber: 11
    }
  })), flyoutContext.isFleetServerFlyoutOpen && /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 213,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_components.FleetServerFlyout, {
    onClose: () => flyoutContext.closeFleetServerFlyout(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 214,
      columnNumber: 11
    }
  })));
});