"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StatusColumn = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _hooks = require("../../../../../../hooks");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/agents/components/manage_auto_upgrade_agents_modal/status_column.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const StatusColumn = ({
  agentPolicyId,
  version,
  percentage
}) => {
  const {
    getHref
  } = (0, _hooks.useLink)();
  const {
    data: autoUpgradeAgentsStatus
  } = (0, _hooks.useGetAutoUpgradeAgentsStatusQuery)(agentPolicyId);
  const getAgentsHref = (0, _react.useCallback)(failed => {
    const kuery = failed ? `policy_id:"${agentPolicyId}" AND upgrade_details.state:"UPG_FAILED" AND upgrade_details.target_version:"${version}"` : `policy_id:"${agentPolicyId}" AND agent.version:"${version}"`;
    return getHref('agent_list', {
      kuery: encodeURIComponent(kuery)
    });
  }, [getHref, agentPolicyId, version]);
  const calcPercentage = (0, _react.useCallback)(agents => autoUpgradeAgentsStatus && autoUpgradeAgentsStatus.totalAgents > 0 ? Math.round(agents / autoUpgradeAgentsStatus.totalAgents * 100) : 0, [autoUpgradeAgentsStatus]);
  const agentVersionCounts = (0, _react.useMemo)(() => {
    var _autoUpgradeAgentsSta;
    return (_autoUpgradeAgentsSta = autoUpgradeAgentsStatus === null || autoUpgradeAgentsStatus === void 0 ? void 0 : autoUpgradeAgentsStatus.currentVersions.find(value => value.version === version)) !== null && _autoUpgradeAgentsSta !== void 0 ? _autoUpgradeAgentsSta : {
      version,
      agents: 0,
      failedUpgradeAgents: 0
    };
  }, [autoUpgradeAgentsStatus, version]);
  const currentPercentage = (0, _react.useMemo)(() => {
    const result = calcPercentage(agentVersionCounts.agents);
    return `${result}%`;
  }, [agentVersionCounts, calcPercentage]);
  const currentStatus = (0, _react.useMemo)(() => {
    const inProgressStatus = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "s",
      href: getAgentsHref(false),
      color: "text",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 65,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "clock",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 66,
        columnNumber: 9
      }
    }), ' ', /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.manageAutoUpgradeAgents.inProgressText",
      defaultMessage: "In progress",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 67,
        columnNumber: 9
      }
    }));
    const failedStatus = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "s",
      href: getAgentsHref(true),
      color: "text",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 74,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "errorFilled",
      color: "danger",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 75,
        columnNumber: 9
      }
    }), ' ', /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.manageAutoUpgradeAgents.failedText",
      defaultMessage: "Upgrade failed",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 76,
        columnNumber: 9
      }
    }));
    const completedStatus = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "s",
      href: getAgentsHref(false),
      color: "text",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 83,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "checkInCircleFilled",
      color: "success",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 84,
        columnNumber: 9
      }
    }), ' ', /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.manageAutoUpgradeAgents.completedText",
      defaultMessage: "Completed",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 85,
        columnNumber: 9
      }
    }));
    const notStartedStatus = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "s",
      color: "text",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 92,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "minusInCircle",
      color: "text",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 93,
        columnNumber: 9
      }
    }), ' ', /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.manageAutoUpgradeAgents.notStartedText",
      defaultMessage: "Not started",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 94,
        columnNumber: 9
      }
    }));
    let statusButton = inProgressStatus;
    if (agentVersionCounts.failedUpgradeAgents > 0) {
      statusButton = failedStatus;
    } else if (agentVersionCounts.agents === 0) {
      statusButton = notStartedStatus;
    } else {
      const currPercentage = calcPercentage(agentVersionCounts.agents);
      if (currPercentage >= percentage) {
        statusButton = completedStatus;
      } else {
        statusButton = inProgressStatus;
      }
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: agentVersionCounts.agents > 0 ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.manageAutoUpgradeAgents.currentStatusTooltip",
        defaultMessage: "{agents, plural, one {# agent} other {# agents}} on target version",
        values: {
          agents: agentVersionCounts.agents
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 119,
          columnNumber: 13
        }
      }) : agentVersionCounts.failedUpgradeAgents > 0 ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.manageAutoUpgradeAgents.failedStatusTooltip",
        defaultMessage: "{failedUpgradeAgents} agents failed to upgrade",
        values: {
          failedUpgradeAgents: agentVersionCounts.failedUpgradeAgents
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 127,
          columnNumber: 13
        }
      }) : null,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 116,
        columnNumber: 7
      }
    }, statusButton);
  }, [agentVersionCounts, percentage, calcPercentage, getAgentsHref]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s",
    alignItems: "center",
    justifyContent: "flexStart",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 9
    }
  }, currentPercentage)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    component: "span",
    grow: 4,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 7
    }
  }, currentStatus));
};
exports.StatusColumn = StatusColumn;