"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.inProgressTitle = exports.inProgressDescription = exports.getAction = exports.formattedTime = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/agents/agent_list_page/components/agent_activity_flyout/helpers.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const actionNames = {
  POLICY_REASSIGN: {
    inProgressText: 'Reassigning',
    completedText: 'assigned to a new policy',
    cancelledText: 'assignment'
  },
  UPGRADE: {
    inProgressText: 'Upgrading',
    completedText: 'upgraded',
    cancelledText: 'upgrade'
  },
  UNENROLL: {
    inProgressText: 'Unenrolling',
    completedText: 'unenrolled',
    cancelledText: 'unenrollment'
  },
  FORCE_UNENROLL: {
    inProgressText: 'Force unenrolling',
    completedText: 'force unenrolled',
    cancelledText: 'force unenrollment'
  },
  AUTOMATIC_FORCE_UNENROLL: {
    inProgressText: 'Automatic unenrolling',
    completedText: 'automatically unenrolled',
    cancelledText: 'automatic unenrollment'
  },
  UPDATE_TAGS: {
    inProgressText: 'Updating tags of',
    completedText: 'updated tags',
    cancelledText: 'update tags'
  },
  CANCEL: {
    inProgressText: 'Cancelling',
    completedText: 'cancelled',
    cancelledText: ''
  },
  REQUEST_DIAGNOSTICS: {
    inProgressText: 'Requesting diagnostics for',
    completedText: 'requested diagnostics',
    cancelledText: 'request diagnostics'
  },
  SETTINGS: {
    inProgressText: 'Updating settings of',
    completedText: 'updated settings',
    cancelledText: 'update settings'
  },
  POLICY_CHANGE: {
    inProgressText: 'Applying policy change on',
    completedText: 'applied policy change',
    cancelledText: 'policy change'
  },
  INPUT_ACTION: {
    inProgressText: 'Input action in progress of',
    completedText: 'input action completed',
    cancelledText: 'input action'
  },
  MIGRATE: {
    inProgressText: 'Migrating',
    completedText: 'migrated',
    cancelledText: 'migration'
  },
  PRIVILEGE_LEVEL_CHANGE: {
    inProgressText: 'Changing privilege level of',
    completedText: 'changed privilege level',
    cancelledText: 'change privilege level'
  },
  ACTION: {
    inProgressText: 'Actioning',
    completedText: 'actioned',
    cancelledText: 'action'
  }
};
const getAction = (type, actionId) => {
  var _actionNames;
  // handling a special case of force unenrollment coming from an automatic task
  // we know what kind of action is from the actionId prefix
  if (actionId !== null && actionId !== void 0 && actionId.includes('UnenrollInactiveAgentsTask-')) return actionNames.AUTOMATIC_FORCE_UNENROLL;
  return (_actionNames = actionNames[type !== null && type !== void 0 ? type : 'ACTION']) !== null && _actionNames !== void 0 ? _actionNames : actionNames.ACTION;
};
exports.getAction = getAction;
const inProgressTitle = (action, isAutomatic) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  gutterSize: "s",
  alignItems: "center",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 86,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.fleet.agentActivity.inProgressTitle",
  defaultMessage: "{inProgressText} {nbAgents} {agents}{reassignText}{upgradeText}{failuresText}{automaticIcon}",
  values: {
    nbAgents: action.nbAgentsAck >= action.nbAgentsActioned ? action.nbAgentsAck : action.nbAgentsAck === 0 ? action.nbAgentsActioned : action.nbAgentsActioned - action.nbAgentsAck + ' of ' + action.nbAgentsActioned,
    agents: action.nbAgentsActioned === 1 ? 'agent' : 'agents',
    inProgressText: getAction(action.type, action.actionId).inProgressText,
    reassignText: action.type === 'POLICY_REASSIGN' && action.newPolicyId ? ` to ${action.newPolicyId}` : '',
    upgradeText: action.type === 'UPGRADE' ? ` to version ${action.version}` : '',
    failuresText: action.nbAgentsFailed > 0 ? `, has ${action.nbAgentsFailed} failure(s)` : '',
    automaticIcon: isAutomatic ? /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      anchorProps: {
        style: {
          display: 'flex',
          alignItems: 'center'
        }
      },
      type: "timeRefresh",
      content: "Triggered by an automatic upgrade",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 106,
        columnNumber: 11
      }
    }) : null
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 87,
    columnNumber: 5
  }
}));
exports.inProgressTitle = inProgressTitle;
const inProgressDescription = time => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.fleet.agentActivityFlyout.startedDescription",
  defaultMessage: "Started on {date}.",
  values: {
    date: formattedTime(time)
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 120,
    columnNumber: 3
  }
});
exports.inProgressDescription = inProgressDescription;
const formattedTime = time => {
  return time ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedDate, {
    value: time,
    year: "numeric",
    month: "short",
    day: "2-digit",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 7
    }
  }), "\xA0", /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedTime, {
    value: time,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 7
    }
  })) : null;
};
exports.formattedTime = formattedTime;