"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogQueryBar = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _hooks = require("../../../../../hooks");
var _constants = require("./constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/agents/agent_details_page/components/agent_logs/query_bar.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const EXCLUDED_FIELDS = [_constants.AGENT_ID_FIELD.name, _constants.DATASET_FIELD.name, _constants.LOG_LEVEL_FIELD.name];
const LogQueryBar = exports.LogQueryBar = /*#__PURE__*/(0, _react.memo)(({
  query,
  isQueryValid,
  onUpdateQuery
}) => {
  const {
    data,
    unifiedSearch: {
      ui: {
        QueryStringInput
      }
    }
  } = (0, _hooks.useStartServices)();
  const [indexPatternFields, setIndexPatternFields] = (0, _react.useState)();
  (0, _react.useEffect)(() => {
    const fetchFields = async () => {
      try {
        const fields = ((await data.dataViews.getFieldsForWildcard({
          pattern: _constants.AGENT_LOG_INDEX_PATTERN
        })) || []).filter(field => {
          return !EXCLUDED_FIELDS.includes(field.name);
        });
        setIndexPatternFields(fields);
      } catch (err) {
        setIndexPatternFields(undefined);
      }
    };
    fetchFields();
  }, [data.dataViews]);
  return /*#__PURE__*/_react.default.createElement(QueryStringInput, {
    iconType: "search",
    autoSubmit: true,
    disableLanguageSwitcher: true,
    indexPatterns: indexPatternFields ? [{
      title: _constants.AGENT_LOG_INDEX_PATTERN,
      fields: indexPatternFields
    }] : [],
    query: {
      query,
      language: 'kuery'
    },
    isInvalid: !isQueryValid,
    disableAutoFocus: true,
    placeholder: _i18n.i18n.translate('xpack.fleet.agentLogs.searchPlaceholderText', {
      defaultMessage: 'Search logs…'
    }),
    onChange: newQuery => {
      onUpdateQuery(newQuery.query);
    },
    onSubmit: newQuery => {
      onUpdateQuery(newQuery.query, true);
    },
    appName: _i18n.i18n.translate('xpack.fleet.appTitle', {
      defaultMessage: 'Fleet'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 5
    }
  });
});