"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentPolicyActionMenu = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _hooks = require("../../../hooks");
var _components = require("../../../components");
var _constants = require("../../../constants");
var _services = require("../../../services");
var _components2 = require("../../agents/components");
var _manage_auto_upgrade_agents_modal = require("../../agents/components/manage_auto_upgrade_agents_modal");
var _use_can_enable_auto_upgrades = require("../../../../../hooks/use_can_enable_auto_upgrades");
var _agent_policy_yaml_flyout = require("./agent_policy_yaml_flyout");
var _agent_policy_copy_provider = require("./agent_policy_copy_provider");
var _agent_policy_delete_provider = require("./agent_policy_delete_provider");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/agent_policy/components/actions_menu.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AgentPolicyActionMenu = exports.AgentPolicyActionMenu = /*#__PURE__*/(0, _react.memo)(({
  agentPolicy,
  onCopySuccess,
  fullButton = false,
  enrollmentFlyoutOpenByDefault = false,
  onCancelEnrollment
}) => {
  var _agentPolicy$package_3;
  const authz = (0, _hooks.useAuthz)();
  const [isYamlFlyoutOpen, setIsYamlFlyoutOpen] = (0, _react.useState)(false);
  const [isEnrollmentFlyoutOpen, setIsEnrollmentFlyoutOpen] = (0, _react.useState)(enrollmentFlyoutOpenByDefault);
  const [isUninstallCommandFlyoutOpen, setIsUninstallCommandFlyoutOpen] = (0, _react.useState)(false);
  const [isUpgradeAgentsModalOpen, setIsUpgradeAgentsModalOpen] = (0, _react.useState)(false);
  const [isManageAutoUpgradeAgentsModalOpen, setIsManageAutoUpgradeAgentsModalOpen] = (0, _react.useState)(false);
  const refreshAgentPolicy = (0, _hooks.useAgentPolicyRefresh)();
  const canEnableAutomaticAgentUpgrades = (0, _use_can_enable_auto_upgrades.useCanEnableAutomaticAgentUpgrades)();
  const isFleetServerPolicy = (0, _react.useMemo)(() => {
    var _agentPolicy$package_, _agentPolicy$package_2;
    return (_agentPolicy$package_ = (_agentPolicy$package_2 = agentPolicy.package_policies) === null || _agentPolicy$package_2 === void 0 ? void 0 : _agentPolicy$package_2.some(packagePolicy => {
      var _packagePolicy$packag;
      return ((_packagePolicy$packag = packagePolicy.package) === null || _packagePolicy$packag === void 0 ? void 0 : _packagePolicy$packag.name) === _constants.FLEET_SERVER_PACKAGE;
    })) !== null && _agentPolicy$package_ !== void 0 ? _agentPolicy$package_ : false;
  }, [agentPolicy]);
  const hasManagedPackagePolicy = 'package_policies' in agentPolicy && (agentPolicy === null || agentPolicy === void 0 ? void 0 : (_agentPolicy$package_3 = agentPolicy.package_policies) === null || _agentPolicy$package_3 === void 0 ? void 0 : _agentPolicy$package_3.some(packagePolicy => packagePolicy.is_managed));
  const [isContextMenuOpen, setIsContextMenuOpen] = (0, _react.useState)(false);
  const onContextMenuChange = (0, _react.useCallback)(open => {
    setIsContextMenuOpen(open);
  }, [setIsContextMenuOpen]);
  const onClose = (0, _react.useMemo)(() => {
    if (onCancelEnrollment) {
      return onCancelEnrollment;
    } else {
      return () => setIsEnrollmentFlyoutOpen(false);
    }
  }, [onCancelEnrollment, setIsEnrollmentFlyoutOpen]);
  return /*#__PURE__*/_react.default.createElement(_agent_policy_copy_provider.AgentPolicyCopyProvider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 7
    }
  }, copyAgentPolicyPrompt => {
    const viewPolicyItem = /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      icon: "inspect",
      onClick: () => {
        setIsContextMenuOpen(false);
        setIsYamlFlyoutOpen(!isYamlFlyoutOpen);
      },
      key: "viewPolicy",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 94,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyActionMenu.viewPolicyText",
      defaultMessage: "View policy",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 102,
        columnNumber: 15
      }
    }));
    const isAuthorizedForAutoUpgradeAgents = authz.fleet.allAgentPolicies && authz.fleet.allAgents;
    const manageAutoUpgradeAgentsItem = /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      "data-test-subj": "agentPolicyActionMenuManageAutoUpgradeAgentsButton",
      icon: "gear",
      disabled: !isAuthorizedForAutoUpgradeAgents,
      toolTipContent: !isAuthorizedForAutoUpgradeAgents && /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentPolicyActionMenu.manageAutoUpgradeAgentsDisabledTooltip",
        defaultMessage: "Agent policies, and Agents 'All' privileges are required to auto-upgrade agents.",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 118,
          columnNumber: 19
        }
      }),
      onClick: () => {
        setIsContextMenuOpen(false);
        setIsManageAutoUpgradeAgentsModalOpen(!isManageAutoUpgradeAgentsModalOpen);
      },
      key: "manageAutoUpgradeAgents",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 112,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyActionMenu.manageAutoUpgradeAgentsText",
      defaultMessage: "Manage auto-upgrade agents",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 130,
        columnNumber: 15
      }
    }));
    const deletePolicyItem = /*#__PURE__*/_react.default.createElement(_agent_policy_delete_provider.AgentPolicyDeleteProvider, {
      hasFleetServer: (0, _services.policyHasFleetServer)(agentPolicy),
      key: "deletePolicy",
      agentPolicy: agentPolicy,
      packagePolicies: agentPolicy.package_policies,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 138,
        columnNumber: 13
      }
    }, deleteAgentPolicyPrompt => /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      "data-test-subj": "agentPolicyActionMenuDeleteButton",
      disabled: !authz.fleet.allAgentPolicies || hasManagedPackagePolicy,
      toolTipContent: hasManagedPackagePolicy ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.policyForm.deletePolicyActionText.disabled",
        defaultMessage: "Agent policy with managed package policies cannot be deleted.",
        "data-test-subj": "agentPolicyActionMenuDeleteButtonDisabledTooltip",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 150,
          columnNumber: 23
        }
      }) : undefined,
      icon: "trash",
      onClick: () => {
        deleteAgentPolicyPrompt(agentPolicy.id);
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 145,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyActionMenu.deletePolicyActionText",
      defaultMessage: "Delete policy",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 162,
        columnNumber: 19
      }
    })));
    const copyPolicyItem = /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      "data-test-subj": "agentPolicyActionMenuCopyButton",
      disabled: !authz.integrations.writeIntegrationPolicies || hasManagedPackagePolicy,
      icon: "copy",
      onClick: () => {
        setIsContextMenuOpen(false);
        copyAgentPolicyPrompt(agentPolicy, onCopySuccess);
      },
      key: "copyPolicy",
      toolTipContent: hasManagedPackagePolicy ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.policyForm.copyPolicyActionText.disabled",
        defaultMessage: "Agent policy with managed package policies cannot be copied.",
        "data-test-subj": "agentPolicyActionMenuCopyButtonDisabledTooltip",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 183,
          columnNumber: 19
        }
      }) : undefined,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 172,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyActionMenu.copyPolicyActionText",
      defaultMessage: "Duplicate policy",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 191,
        columnNumber: 15
      }
    }));
    const managedMenuItems = [viewPolicyItem];
    const agentBasedActionsDisabledTooltipText = isFleetServerPolicy ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyActionMenu.addFleetServerDisabledTooltip",
      defaultMessage: "Fleet settings, Agent policies, and Agents 'All' privileges are required to add a Fleet Server.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 200,
        columnNumber: 13
      }
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyActionMenu.enrollAgentDisabledTooltip",
      defaultMessage: "Agents 'All' privilege is required to enroll agents.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 205,
        columnNumber: 13
      }
    });
    const isAuthorizedForAgentAction = isFleetServerPolicy && authz.fleet.addFleetServers || !isFleetServerPolicy && authz.fleet.addAgents;
    const agentBasedMenuItems = [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      icon: "plusInCircle",
      disabled: !isAuthorizedForAgentAction,
      "data-test-subj": "agentPolicyActionMenuAddAgentButton",
      toolTipContent: !isAuthorizedForAgentAction && agentBasedActionsDisabledTooltipText,
      onClick: () => {
        setIsContextMenuOpen(false);
        setIsEnrollmentFlyoutOpen(true);
      },
      key: "enrollAgents",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 215,
        columnNumber: 13
      }
    }, isFleetServerPolicy ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyActionMenu.addFleetServerActionText",
      defaultMessage: "Add Fleet Server",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 227,
        columnNumber: 17
      }
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyActionMenu.enrollAgentActionText",
      defaultMessage: "Add agent",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 232,
        columnNumber: 17
      }
    })), viewPolicyItem, ...(canEnableAutomaticAgentUpgrades ? [manageAutoUpgradeAgentsItem] : []), copyPolicyItem, deletePolicyItem];
    const agentlessMenuItems = [viewPolicyItem, deletePolicyItem];
    let menuItems;
    if (agentPolicy !== null && agentPolicy !== void 0 && agentPolicy.is_managed) {
      menuItems = managedMenuItems;
    } else if (agentPolicy !== null && agentPolicy !== void 0 && agentPolicy.supports_agentless) {
      menuItems = agentlessMenuItems;
    } else {
      menuItems = agentBasedMenuItems;
    }
    if (authz.fleet.allAgents && !(agentPolicy !== null && agentPolicy !== void 0 && agentPolicy.is_managed) && !(agentPolicy !== null && agentPolicy !== void 0 && agentPolicy.supports_agentless)) {
      menuItems.push(/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
        icon: "refresh",
        onClick: () => {
          setIsUpgradeAgentsModalOpen(true);
        },
        key: "upgradeAgents",
        "data-test-subj": "agentPolicyActionMenuUpgradeAgentsButton",
        disabled: (agentPolicy.agents || 0) === 0,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 261,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentPolicyActionMenu.upgradeAgentsActionText",
        defaultMessage: "Upgrade agents on this policy",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 270,
          columnNumber: 17
        }
      })));
    }
    if (authz.fleet.allAgents && !(agentPolicy !== null && agentPolicy !== void 0 && agentPolicy.is_managed) && !(agentPolicy !== null && agentPolicy !== void 0 && agentPolicy.supports_agentless)) {
      menuItems.push(/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
        icon: "minusInCircle",
        onClick: () => {
          setIsContextMenuOpen(false);
          setIsUninstallCommandFlyoutOpen(true);
        },
        key: "getUninstallCommand",
        "data-test-subj": "uninstall-agents-command-menu-item",
        disabled: (agentPolicy.agents || 0) === 0,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 284,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentPolicyActionMenu.getUninstallCommand",
        defaultMessage: "Uninstall agents on this policy",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 294,
          columnNumber: 17
        }
      })));
    }
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isYamlFlyoutOpen && /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 305,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_agent_policy_yaml_flyout.AgentPolicyYamlFlyout, {
      policyId: agentPolicy.id,
      onClose: () => setIsYamlFlyoutOpen(false),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 306,
        columnNumber: 19
      }
    })), isEnrollmentFlyoutOpen && /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 313,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_components.AgentEnrollmentFlyout, {
      agentPolicy: agentPolicy,
      onClose: onClose,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 314,
        columnNumber: 19
      }
    })), isUpgradeAgentsModalOpen && /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 318,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_components2.AgentUpgradeAgentModal, {
      agents: `policy_id:"${agentPolicy.id}"`,
      agentCount: agentPolicy.agents || 0,
      onClose: () => {
        setIsUpgradeAgentsModalOpen(false);
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 319,
        columnNumber: 19
      }
    })), isManageAutoUpgradeAgentsModalOpen && /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 329,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_manage_auto_upgrade_agents_modal.ManageAutoUpgradeAgentsModal, {
      agentPolicy: agentPolicy,
      agentCount: agentPolicy.agents || 0,
      onClose: refreshPolicy => {
        setIsManageAutoUpgradeAgentsModalOpen(false);
        if (refreshPolicy) {
          refreshAgentPolicy();
        }
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 330,
        columnNumber: 19
      }
    })), isUninstallCommandFlyoutOpen && /*#__PURE__*/_react.default.createElement(_components.UninstallCommandFlyout, {
      target: "agent",
      policyId: agentPolicy.id,
      onClose: () => setIsUninstallCommandFlyoutOpen(false),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 343,
        columnNumber: 17
      }
    }), /*#__PURE__*/_react.default.createElement(_components.ContextMenuActions, {
      isOpen: isContextMenuOpen,
      onChange: onContextMenuChange,
      button: fullButton ? {
        props: {
          iconType: 'arrowDown',
          iconSide: 'right'
        },
        children: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.agentPolicyActionMenu.buttonText",
          defaultMessage: "Actions",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 360,
            columnNumber: 27
          }
        })
      } : undefined,
      items: menuItems,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 349,
        columnNumber: 15
      }
    }));
  });
});