"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFieldSpecs = exports.SearchBar = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _esQuery = require("@kbn/es-query");
var _public = require("@kbn/unified-search-plugin/public");
var _i18n = require("@kbn/i18n");
var _hooks = require("../hooks");
var _constants = require("../constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/components/search_bar.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const NoWrapQueryStringInput = (0, _styledComponents.default)(_public.QueryStringInput)`
  .kbnQueryBar__textarea {
    white-space: nowrap;
  }
`;
const getMappings = (indexPattern, fieldPrefix) => {
  switch (indexPattern) {
    case _constants.AGENTS_INDEX:
      return _constants.AGENT_MAPPINGS;
    // Saved Objects are stored in .kibana_ingest.
    // Currently, the search bar is only used to query agent policies.
    case _constants.INGEST_SAVED_OBJECT_INDEX:
      switch (fieldPrefix) {
        case _constants.AGENT_POLICY_SAVED_OBJECT_TYPE:
          return _constants.AGENT_POLICY_MAPPINGS;
        case _constants.LEGACY_AGENT_POLICY_SAVED_OBJECT_TYPE:
          return _constants.AGENT_POLICY_MAPPINGS;
        default:
          return {};
      }
    case _constants.ENROLLMENT_API_KEYS_INDEX:
      return _constants.ENROLLMENT_API_KEY_MAPPINGS;
    default:
      return {};
  }
};
const getFieldName = (indexPattern, fieldPrefix, name) => {
  // Add Saved Object prefix if the field refers to a SO and is not already prefixed.
  if (indexPattern !== _constants.INGEST_SAVED_OBJECT_INDEX || name.startsWith(fieldPrefix)) {
    return name;
  }
  return `${fieldPrefix}.${name}`;
};
const getFieldType = type => {
  switch (type) {
    case 'keyword':
      return 'string';
    case 'text':
      return 'string';
    case 'version':
      return 'string';
    case 'integer':
      return 'number';
    case 'double':
      return 'number';
    default:
      return type;
  }
};
const concatKeys = (obj, parentKey = '') => {
  let result = [];
  for (const key in obj) {
    if (typeof obj[key] === 'object') {
      result = result.concat(concatKeys(obj[key], `${parentKey}${key}.`));
    } else {
      result.push(`${parentKey}${key}:${obj[key]}`);
    }
  }
  return result;
};

/** Exported for testing only **/
const getFieldSpecs = (indexPattern, fieldPrefix) => {
  const mapping = getMappings(indexPattern, fieldPrefix);
  // @ts-ignore-next-line
  const rawFields = concatKeys(mapping === null || mapping === void 0 ? void 0 : mapping.properties) || [];
  const fields = rawFields.map(field => field.replaceAll(/.properties/g, '')).map(field => field.replace(/.type/g, '')).map(field => field.split(':'));
  const fieldSpecs = fields.map(field => {
    return {
      name: getFieldName(indexPattern, fieldPrefix, field[0]),
      type: getFieldType(field[1]),
      searchable: true,
      aggregatable: true,
      esTypes: [field[1]]
    };
  });
  return fieldSpecs;
};
exports.getFieldSpecs = getFieldSpecs;
const SearchBar = ({
  value,
  fieldPrefix,
  onChange,
  placeholder,
  indexPattern,
  dataTestSubj
}) => {
  const {
    data,
    dataViews,
    unifiedSearch,
    storage,
    notifications,
    http,
    docLinks,
    uiSettings,
    usageCollection
  } = (0, _hooks.useStartServices)();
  const [dataView, setDataView] = (0, _react.useState)();
  const isQueryValid = (0, _react.useMemo)(() => {
    if (!value || value === '') {
      return true;
    }
    try {
      (0, _esQuery.fromKueryExpression)(value);
      return true;
    } catch (e) {
      return false;
    }
  }, [value]);
  (0, _react.useEffect)(() => {
    const fetchFields = async () => {
      try {
        const fieldSpecs = getFieldSpecs(indexPattern, fieldPrefix);
        const fieldsMap = data.dataViews.fieldArrayToMap(fieldSpecs);
        const newDataView = await data.dataViews.create({
          title: indexPattern,
          fields: fieldsMap
        }, true);
        setDataView(newDataView);
      } catch (err) {
        setDataView(undefined);
      }
    };
    fetchFields();
  }, [data.dataViews, fieldPrefix, indexPattern]);
  return /*#__PURE__*/_react.default.createElement(NoWrapQueryStringInput, (0, _extends2.default)({
    iconType: "search",
    disableLanguageSwitcher: true,
    indexPatterns: dataView ? [dataView] : [],
    query: {
      query: value,
      language: 'kuery'
    },
    isInvalid: !isQueryValid,
    disableAutoFocus: true,
    placeholder: placeholder,
    onChange: newQuery => {
      onChange(newQuery.query);
    },
    onSubmit: newQuery => {
      onChange(newQuery.query, true);
    },
    submitOnBlur: true,
    isClearable: true,
    autoSubmit: true,
    appName: _i18n.i18n.translate('xpack.fleet.appTitle', {
      defaultMessage: 'Fleet'
    }),
    deps: {
      unifiedSearch,
      notifications,
      http,
      docLinks,
      uiSettings,
      data,
      dataViews,
      storage,
      usageCollection
    }
  }, dataTestSubj && {
    dataTestSubj
  }, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 5
    }
  }));
};
exports.SearchBar = SearchBar;