"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSelectAgentPolicyStep = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _ = require("../..");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/components/fleet_server_instructions/steps/select_agent_policy.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getSelectAgentPolicyStep = ({
  policyId,
  setPolicyId,
  eligibleFleetServerPolicies,
  refreshEligibleFleetServerPolicies
}) => {
  return {
    title: eligibleFleetServerPolicies.length === 0 && !policyId ? _i18n.i18n.translate('xpack.fleet.fleetServerSetup.stepCreateAgentPolicyTitle', {
      defaultMessage: 'Create a policy for Fleet Server'
    }) : _i18n.i18n.translate('xpack.fleet.fleetServerSetup.stepSelectAgentPolicyTitle', {
      defaultMessage: 'Select a policy for Fleet Server'
    }),
    status: policyId ? 'complete' : undefined,
    children: /*#__PURE__*/_react.default.createElement(SelectAgentPolicyStepContent, {
      policyId: policyId,
      setPolicyId: setPolicyId,
      eligibleFleetServerPolicies: eligibleFleetServerPolicies,
      refreshEligibleFleetServerPolicies: refreshEligibleFleetServerPolicies,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 38,
        columnNumber: 7
      }
    })
  };
};
exports.getSelectAgentPolicyStep = getSelectAgentPolicyStep;
const SelectAgentPolicyStepContent = ({
  policyId,
  setPolicyId,
  eligibleFleetServerPolicies,
  refreshEligibleFleetServerPolicies
}) => {
  (0, _react.useEffect)(() => {
    // Select default value
    if (eligibleFleetServerPolicies.length === 1 && !policyId) {
      setPolicyId(eligibleFleetServerPolicies[0].id);
    }
  }, [eligibleFleetServerPolicies, policyId, setPolicyId]);
  const setSelectedPolicyId = agentPolicyId => {
    setPolicyId(agentPolicyId);
  };
  return /*#__PURE__*/_react.default.createElement(_.SelectCreateAgentPolicy, {
    agentPolicies: eligibleFleetServerPolicies,
    withKeySelection: false,
    selectedPolicyId: policyId,
    setSelectedPolicyId: setSelectedPolicyId,
    refreshAgentPolicies: refreshEligibleFleetServerPolicies,
    excludeFleetServer: false,
    isFleetServerPolicy: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 5
    }
  });
};