"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReactExpressionRenderer = ReactExpressionRenderer;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _panelLoader = require("@kbn/panel-loader");
var _use_expression_renderer = require("./use_expression_renderer");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/expressions/public/react_expression_renderer/react_expression_renderer.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// Accept all options of the runner as props except for the
// dom element which is provided by the component itself

function ReactExpressionRenderer({
  className,
  dataAttrs,
  padding,
  renderError,
  abortController,
  ...expressionRendererOptions
}) {
  const nodeRef = (0, _react.useRef)(null);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    error,
    isEmpty,
    isLoading
  } = (0, _use_expression_renderer.useExpressionRenderer)(nodeRef, {
    ...expressionRendererOptions,
    hasCustomErrorRenderer: !!renderError
  });
  return /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({}, dataAttrs, {
    className: className,
    css: styles,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 5
    }
  }), isEmpty && /*#__PURE__*/_react.default.createElement(_panelLoader.PanelLoader, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 19
    }
  }), isLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    size: "xs",
    color: "accent",
    position: "absolute",
    css: {
      zIndex: 1
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 9
    }
  }), !isLoading && error && (renderError === null || renderError === void 0 ? void 0 : renderError(error.message, error)), /*#__PURE__*/_react.default.createElement("div", {
    className: "expExpressionRenderer__expression",
    css: (0, _react2.css)({
      width: '100%',
      height: '100%',
      ...(padding ? {
        padding: euiTheme.size[padding]
      } : {}),
      ...(isEmpty || !!error ? {
        display: 'none'
      } : {})
    }),
    ref: nodeRef,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 7
    }
  }));
}
const styles = (0, _react2.css)({
  position: 'relative',
  display: 'flex',
  width: '100%',
  height: '100%',
  alignItems: 'center',
  justifyContent: 'center'
});