"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.XYChart = XYChart;
exports.XYChartReportable = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _charts = require("@elastic/charts");
var _lodash = require("lodash");
var _i18n = require("@kbn/i18n");
var _esQuery = require("@kbn/es-query");
var _palettes = require("@kbn/palettes");
var _common = require("@kbn/data-plugin/common");
var _public = require("@kbn/charts-plugin/public");
var _utils = require("@kbn/visualizations-plugin/common/utils");
var _constants = require("@kbn/visualizations-plugin/common/constants");
var _chartExpressionsCommon = require("@kbn/chart-expressions-common");
var _coreRenderingBrowser = require("@kbn/core-rendering-browser");
var _reactKibanaContextTheme = require("@kbn/react-kibana-context-theme");
var _helpers = require("../../common/helpers");
var _helpers2 = require("../helpers");
var _x_domain = require("./x_domain");
var _legend_action = require("./legend_action");
var _reference_lines = require("./reference_lines");
var _definitions = require("../definitions");
var _split_chart = require("./split_chart");
var _annotations = require("./annotations");
var _constants2 = require("../../common/constants");
var _data_layers = require("./data_layers");
var _tooltip = require("./tooltip");
var _xy_current_time = require("./xy_current_time");
var _legend_color_picker = require("./legend_color_picker");
var _tooltip_actions = require("./tooltip/tooltip_actions");
var _xy_chart = require("./xy_chart.styles");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/chart_expressions/expression_xy/public/components/xy_chart.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MULTILAYER_TIME_AXIS_TICKLINE_PADDING = 4;
function nonNullable(v) {
  return v != null;
}
function getValueLabelsStyling(isHorizontal) {
  const VALUE_LABELS_MAX_FONTSIZE = 12;
  const VALUE_LABELS_MIN_FONTSIZE = 10;
  const VALUE_LABELS_VERTICAL_OFFSET = -10;
  const VALUE_LABELS_HORIZONTAL_OFFSET = 10;
  return {
    displayValue: {
      fontSize: {
        min: VALUE_LABELS_MIN_FONTSIZE,
        max: VALUE_LABELS_MAX_FONTSIZE
      },
      fill: {
        textBorder: 0
      },
      alignment: isHorizontal ? {
        vertical: _charts.VerticalAlignment.Middle
      } : {
        horizontal: _charts.HorizontalAlignment.Center
      },
      offsetX: isHorizontal ? VALUE_LABELS_HORIZONTAL_OFFSET : 0,
      offsetY: isHorizontal ? 0 : VALUE_LABELS_VERTICAL_OFFSET
    }
  };
}
function getIconForSeriesType(layer) {
  var _visualizationDefinit;
  return ((_visualizationDefinit = _definitions.visualizationDefinitions.find(c => c.id === `${layer.seriesType}${layer.isHorizontal ? '_horizontal' : ''}${layer.isPercentage ? '_percentage' : ''}${layer.isStacked ? '_stacked' : ''}`)) === null || _visualizationDefinit === void 0 ? void 0 : _visualizationDefinit.icon) || 'empty';
}
const XYChartReportable = exports.XYChartReportable = /*#__PURE__*/_react.default.memo(XYChart);
function XYChart({
  args,
  data,
  formatFactory,
  timeZone,
  chartsThemeService,
  chartsActiveCursorService,
  paletteService,
  minInterval,
  onClickValue,
  onClickMultiValue,
  onCreateAlertRule,
  layerCellValueActions,
  onSelectRange,
  setChartSize,
  interactive = true,
  syncColors,
  syncTooltips,
  syncCursor,
  renderComplete,
  uiState,
  timeFormat,
  overrides
}) {
  var _getDataLayers, _dataLayers$, _yAxesMap$left$showTi, _yAxesMap$left, _yAxesMap$right$showT, _yAxesMap$right, _yAxesMap$left$showLa, _yAxesMap$left2, _yAxesMap$right$showL, _yAxesMap$right2, _legend$verticalAlign, _legend$horizontalAli, _legend$floatingColum, _window$_echDebugStat, _legend$legendSize, _legend$maxLines, _dataLayers$3, _dataLayers$4;
  const {
    legend,
    layers,
    fittingFunction,
    endValue,
    emphasizeFitting,
    valueLabels,
    hideEndzones,
    yAxisConfigs,
    xAxisConfig,
    splitColumnAccessor,
    splitRowAccessor,
    singleTable,
    annotations,
    pointVisibility
  } = args;
  const chartRef = (0, _react.useRef)(null);
  const chartBaseTheme = chartsThemeService.useChartsBaseTheme();
  const darkMode = (0, _reactKibanaContextTheme.useKibanaIsDarkMode)();
  const palettes = (0, _palettes.useKbnPalettes)();
  const appFixedViewport = (0, _coreRenderingBrowser.useAppFixedViewport)();
  const filteredLayers = (0, _helpers2.getFilteredLayers)(layers);
  const layersById = filteredLayers.reduce((hashMap, layer) => ({
    ...hashMap,
    [layer.layerId]: layer
  }), {});
  const chartHasMoreThanOneSeries = filteredLayers.length > 1 || filteredLayers.some(layer => layer.accessors.length > 1) || filteredLayers.some(layer => (0, _helpers2.isDataLayer)(layer) && layer.splitAccessors && layer.splitAccessors.length);
  const getShowLegendDefault = (0, _react.useCallback)(() => {
    var _uiState$get;
    const legendStateDefault = legend.isVisible && !legend.showSingleSeries ? chartHasMoreThanOneSeries : legend.isVisible;
    return (_uiState$get = uiState === null || uiState === void 0 ? void 0 : uiState.get('vis.legendOpen', legendStateDefault)) !== null && _uiState$get !== void 0 ? _uiState$get : legendStateDefault;
  }, [chartHasMoreThanOneSeries, legend.isVisible, legend.showSingleSeries, uiState]);
  const [showLegend, setShowLegend] = (0, _react.useState)(() => getShowLegendDefault());
  (0, _react.useEffect)(() => {
    const legendShow = getShowLegendDefault();
    setShowLegend(legendShow);
  }, [getShowLegendDefault]);
  const toggleLegend = (0, _react.useCallback)(() => {
    setShowLegend(value => {
      var _uiState$set;
      const newValue = !value;
      uiState === null || uiState === void 0 ? void 0 : (_uiState$set = uiState.set) === null || _uiState$set === void 0 ? void 0 : _uiState$set.call(uiState, 'vis.legendOpen', newValue);
      return newValue;
    });
  }, [uiState]);
  const setColor = (0, _react.useCallback)((newColor, seriesLabel) => {
    const colors = (uiState === null || uiState === void 0 ? void 0 : uiState.get('vis.colors')) || {};
    if (colors[seriesLabel] === newColor || !newColor) {
      delete colors[seriesLabel];
    } else {
      colors[seriesLabel] = newColor;
    }
    uiState === null || uiState === void 0 ? void 0 : uiState.setSilent('vis.colors', null);
    uiState === null || uiState === void 0 ? void 0 : uiState.set('vis.colors', colors);
    uiState === null || uiState === void 0 ? void 0 : uiState.emit('reload');
    uiState === null || uiState === void 0 ? void 0 : uiState.emit('colorChanged');
  }, [uiState]);

  // Exclude the reference layers from the cursor update
  const cursorSyncLayers = filteredLayers.filter(_helpers2.isDataLayer);
  const handleCursorUpdate = (0, _public.useActiveCursor)(chartsActiveCursorService, chartRef, {
    datatables: cursorSyncLayers.map(({
      table
    }) => table)
  });
  const onRenderChange = (0, _react.useCallback)((isRendered = true) => {
    if (isRendered) {
      renderComplete();
    }
  }, [renderComplete]);
  const dataLayers = filteredLayers.filter(_helpers2.isDataLayer);
  const isTimeViz = (0, _helpers.isTimeChart)(dataLayers);
  (0, _react.useEffect)(() => {
    const chartSizeSpec = isTimeViz && !(0, _helpers2.isHorizontalChart)(dataLayers) ? {
      aspectRatio: {
        x: 16,
        y: 9
      },
      minDimensions: {
        y: {
          value: 300,
          unit: 'pixels'
        },
        x: {
          value: 100,
          unit: 'percentage'
        }
      }
    } : {
      maxDimensions: {
        x: {
          value: 100,
          unit: 'percentage'
        },
        y: {
          value: 100,
          unit: 'percentage'
        }
      }
    };
    setChartSize(chartSizeSpec);
  }, [dataLayers, isTimeViz, setChartSize]);
  const formattedDatatables = (0, _react.useMemo)(() => (0, _helpers2.getFormattedTablesByLayers)(dataLayers, formatFactory, splitColumnAccessor, splitRowAccessor), [dataLayers, formatFactory, splitColumnAccessor, splitRowAccessor]);
  const fieldFormats = (0, _react.useMemo)(() => (0, _helpers2.getLayersFormats)(dataLayers, {
    splitColumnAccessor,
    splitRowAccessor
  }, formatFactory), [dataLayers, splitColumnAccessor, splitRowAccessor, formatFactory]);
  const icon = getIconForSeriesType((_getDataLayers = (0, _helpers2.getDataLayers)(layers)) === null || _getDataLayers === void 0 ? void 0 : _getDataLayers[0]);
  if (dataLayers.length === 0) {
    return /*#__PURE__*/_react.default.createElement(_public.EmptyPlaceholder, {
      icon: icon,
      renderComplete: onRenderChange,
      css: xyChartEmptyStyles,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 352,
        columnNumber: 7
      }
    });
  }

  // use formatting hint of first x axis column to format ticks
  const xAxisColumn = dataLayers[0].xAccessor ? (0, _utils.getColumnByAccessor)(dataLayers[0].xAccessor, (_dataLayers$ = dataLayers[0]) === null || _dataLayers$ === void 0 ? void 0 : _dataLayers$.table.columns) : undefined;
  const xAxisFormatter = formatFactory(xAxisColumn !== null && xAxisColumn !== void 0 && xAxisColumn.id ? fieldFormats[dataLayers[0].layerId].xAccessors[xAxisColumn === null || xAxisColumn === void 0 ? void 0 : xAxisColumn.id] : undefined);

  // This is a safe formatter for the xAccessor that abstracts the knowledge of already formatted layers
  const safeXAccessorLabelRenderer = value => {
    var _formattedDatatables$, _dataLayers$2;
    return xAxisColumn && (_formattedDatatables$ = formattedDatatables[(_dataLayers$2 = dataLayers[0]) === null || _dataLayers$2 === void 0 ? void 0 : _dataLayers$2.layerId]) !== null && _formattedDatatables$ !== void 0 && _formattedDatatables$.formattedColumns[xAxisColumn.id] ? String(value) : String(xAxisFormatter.convert(value));
  };
  const shouldRotate = (0, _helpers2.isHorizontalChart)(dataLayers);
  const yAxesConfiguration = (0, _helpers2.getAxesConfiguration)(dataLayers, shouldRotate, formatFactory, fieldFormats, yAxisConfigs);
  const axesConfiguration = (0, _helpers2.getAxesConfiguration)(dataLayers, shouldRotate, formatFactory, fieldFormats, [...(yAxisConfigs !== null && yAxisConfigs !== void 0 ? yAxisConfigs : []), ...(xAxisConfig ? [xAxisConfig] : [])]);
  const xTitle = (xAxisConfig === null || xAxisConfig === void 0 ? void 0 : xAxisConfig.title) || xAxisColumn && xAxisColumn.name || undefined;
  const yAxesMap = {
    left: yAxesConfiguration.find(({
      position
    }) => position === (0, _helpers2.getAxisPosition)(_charts.Position.Left, shouldRotate)),
    right: yAxesConfiguration.find(({
      position
    }) => position === (0, _helpers2.getAxisPosition)(_charts.Position.Right, shouldRotate))
  };
  const titles = (0, _helpers2.getLayersTitles)(dataLayers, {
    splitColumnAccessor,
    splitRowAccessor
  }, {
    xTitle
  }, yAxesConfiguration);
  const filteredBarLayers = dataLayers.filter(({
    seriesType
  }) => seriesType === _constants2.SeriesTypes.BAR);
  const chartHasMoreThanOneBarSeries = filteredBarLayers.length > 1 || filteredBarLayers.some(layer => layer.accessors.length > 1) || filteredBarLayers.some(layer => (0, _helpers2.isDataLayer)(layer) && layer.splitAccessors && layer.splitAccessors.length);
  const defaultXScaleType = isTimeViz ? _constants2.XScaleTypes.TIME : _constants2.XScaleTypes.ORDINAL;
  const isHistogramViz = dataLayers.every(l => l.isHistogram);
  const isEsqlMode = dataLayers.some(l => {
    var _l$table, _l$table$meta;
    return ((_l$table = l.table) === null || _l$table === void 0 ? void 0 : (_l$table$meta = _l$table.meta) === null || _l$table$meta === void 0 ? void 0 : _l$table$meta.type) === _common.ESQL_TABLE_TYPE;
  });
  const hasBars = dataLayers.some(l => l.seriesType === _constants2.SeriesTypes.BAR);
  const {
    baseDomain: rawXDomain,
    extendedDomain: xDomain
  } = (0, _x_domain.getXDomain)(data.datatableUtilities, dataLayers, minInterval, isTimeViz, isHistogramViz, hasBars, timeZone, xAxisConfig === null || xAxisConfig === void 0 ? void 0 : xAxisConfig.extent);
  const axisTitlesVisibilitySettings = {
    yLeft: (_yAxesMap$left$showTi = yAxesMap === null || yAxesMap === void 0 ? void 0 : (_yAxesMap$left = yAxesMap.left) === null || _yAxesMap$left === void 0 ? void 0 : _yAxesMap$left.showTitle) !== null && _yAxesMap$left$showTi !== void 0 ? _yAxesMap$left$showTi : true,
    yRight: (_yAxesMap$right$showT = yAxesMap === null || yAxesMap === void 0 ? void 0 : (_yAxesMap$right = yAxesMap.right) === null || _yAxesMap$right === void 0 ? void 0 : _yAxesMap$right.showTitle) !== null && _yAxesMap$right$showT !== void 0 ? _yAxesMap$right$showT : true
  };
  const tickLabelsVisibilitySettings = {
    yLeft: (_yAxesMap$left$showLa = yAxesMap === null || yAxesMap === void 0 ? void 0 : (_yAxesMap$left2 = yAxesMap.left) === null || _yAxesMap$left2 === void 0 ? void 0 : _yAxesMap$left2.showLabels) !== null && _yAxesMap$left$showLa !== void 0 ? _yAxesMap$left$showLa : true,
    yRight: (_yAxesMap$right$showL = yAxesMap === null || yAxesMap === void 0 ? void 0 : (_yAxesMap$right2 = yAxesMap.right) === null || _yAxesMap$right2 === void 0 ? void 0 : _yAxesMap$right2.showLabels) !== null && _yAxesMap$right$showL !== void 0 ? _yAxesMap$right$showL : true
  };
  const getYAxesTitles = axisSeries => {
    return axisSeries.map(({
      layer,
      accessor
    }) => {
      var _titles$layer, _titles$layer$yTitles;
      return titles === null || titles === void 0 ? void 0 : (_titles$layer = titles[layer]) === null || _titles$layer === void 0 ? void 0 : (_titles$layer$yTitles = _titles$layer.yTitles) === null || _titles$layer$yTitles === void 0 ? void 0 : _titles$layer$yTitles[accessor];
    }).find(name => Boolean(name));
  };
  const referenceLineLayers = (0, _helpers2.getReferenceLayers)(layers);
  const [rangeAnnotations, lineAnnotations] = isTimeViz ? (0, _lodash.partition)(annotations === null || annotations === void 0 ? void 0 : annotations.datatable.rows, _annotations.isRangeAnnotation) : [[], []];
  const groupedLineAnnotations = (0, _annotations.getAnnotationsGroupedByInterval)(lineAnnotations, annotations === null || annotations === void 0 ? void 0 : annotations.layers.flatMap(l => l.annotations), annotations === null || annotations === void 0 ? void 0 : annotations.datatable.columns, formatFactory, timeFormat);
  const visualConfigs = [...referenceLineLayers.flatMap(({
    decorations
  }) => decorations).map(config => {
    var _getAxisGroupForRefer, _getAxisGroupForRefer2;
    return {
      ...config,
      position: config ? (_getAxisGroupForRefer = (_getAxisGroupForRefer2 = (0, _reference_lines.getAxisGroupForReferenceLine)(axesConfiguration, config, shouldRotate)) === null || _getAxisGroupForRefer2 === void 0 ? void 0 : _getAxisGroupForRefer2.position) !== null && _getAxisGroupForRefer !== void 0 ? _getAxisGroupForRefer : _charts.Position.Left : _charts.Position.Bottom
    };
  }), ...groupedLineAnnotations].filter(nonNullable);
  const shouldHideDetails = annotations !== null && annotations !== void 0 && annotations.layers && annotations.layers.length > 0 ? annotations === null || annotations === void 0 ? void 0 : annotations.layers[0].simpleView : false;
  const linesPaddings = !shouldHideDetails ? (0, _helpers2.getLinesCausedPaddings)(visualConfigs, yAxesMap, shouldRotate) : {};
  const getYAxesStyle = axis => {
    const tickVisible = axis.showLabels;
    const position = (0, _helpers2.getOriginalAxisPosition)(axis.position, shouldRotate);
    const style = {
      tickLabel: {
        fill: axis.labelColor,
        visible: tickVisible,
        rotation: axis.labelsOrientation,
        padding: linesPaddings[position] != null ? {
          inner: linesPaddings[position]
        } : undefined
      },
      axisTitle: {
        visible: axis.showTitle,
        // if labels are not visible add the padding to the title
        padding: !tickVisible && linesPaddings[position] != null ? {
          inner: linesPaddings[position]
        } : undefined
      }
    };
    return style;
  };
  const getYAxisDomain = axis => {
    var _axis$extent;
    const extent = axis.extent || {
      type: 'axisExtentConfig',
      mode: 'full'
    };
    const hasBarOrArea = Boolean(axis.series.some(series => {
      const layer = layersById[series.layer];
      if (!(layer && (0, _helpers2.isDataLayer)(layer))) {
        return false;
      }
      return layer.seriesType === _constants2.SeriesTypes.BAR || layer.seriesType === _constants2.SeriesTypes.AREA;
    }));
    const fit = Boolean((!hasBarOrArea || ((_axis$extent = axis.extent) === null || _axis$extent === void 0 ? void 0 : _axis$extent.enforce)) && extent.mode === _constants2.AxisExtentModes.DATA_BOUNDS);
    const padding = axis.boundsMargin || undefined;
    let min = NaN;
    let max = NaN;
    if (extent.mode === 'custom') {
      const validExtent = (0, _helpers2.validateExtent)(hasBarOrArea, extent);
      if (validExtent || extent.enforce) {
        var _extent$lowerBound, _extent$upperBound;
        min = (_extent$lowerBound = extent.lowerBound) !== null && _extent$lowerBound !== void 0 ? _extent$lowerBound : NaN;
        max = (_extent$upperBound = extent.upperBound) !== null && _extent$upperBound !== void 0 ? _extent$upperBound : NaN;
      }
    }
    return {
      fit,
      min,
      max,
      padding,
      includeDataFromIds: referenceLineLayers.flatMap(l => {
        var _l$decorations;
        return ((_l$decorations = l.decorations) === null || _l$decorations === void 0 ? void 0 : _l$decorations.map(decoration => ({
          layerId: l.layerId,
          decoration
        }))) || [];
      }).filter(({
        decoration
      }) => {
        var _decoration$position;
        if (decoration.axisId) {
          return axis.groupId.includes(decoration.axisId);
        }
        return axis.position === (0, _helpers2.getAxisPosition)((_decoration$position = decoration.position) !== null && _decoration$position !== void 0 ? _decoration$position : _charts.Position.Left, shouldRotate);
      }).map(({
        layerId,
        decoration
      }) => (0, _helpers2.isReferenceLineDecorationConfig)(decoration) ? `${layerId}-${decoration.value}-${decoration.fill !== 'none' ? 'rect' : 'line'}` : `${layerId}-${decoration.forAccessor}-${decoration.fill !== 'none' ? 'rect' : 'line'}`)
    };
  };
  const shouldShowValueLabels = !uiState || valueLabels !== _constants2.ValueLabelModes.HIDE;
  const valueLabelsStyling = shouldShowValueLabels && valueLabels !== _constants2.ValueLabelModes.HIDE && getValueLabelsStyling(shouldRotate);
  const clickHandler = ([elementEvent]) => {
    // this cast is safe because we are rendering a cartesian chart
    const [xyGeometry, xySeries] = elementEvent;
    const layer = dataLayers.find(l => xySeries.seriesKeys.some(key => l.accessors.some(accessor => (0, _utils.getAccessorByDimension)(accessor, l.table.columns) === key.toString())));
    if (!layer) {
      return;
    }
    const {
      table
    } = layer;
    const xSeriesPoint = (0, _tooltip_actions.getXSeriesPoint)(layer, xyGeometry.x, fieldFormats, formattedDatatables, xAxisFormatter, formatFactory);
    const splitPoints = [];
    if (xySeries.seriesKeys.length > 1) {
      xySeries.splitAccessors.forEach((value, accessor) => {
        const point = (0, _tooltip_actions.createSplitPoint)(accessor, value, formattedDatatables[layer.layerId].table.rows, table);
        if (point) {
          splitPoints.push(point);
        }
      });
    }
    if (xySeries.smHorizontalAccessorValue && splitColumnAccessor) {
      const accessor = (0, _utils.getAccessorByDimension)(splitColumnAccessor, table.columns);
      const point = (0, _tooltip_actions.createSplitPoint)(accessor, xySeries.smHorizontalAccessorValue, formattedDatatables[layer.layerId].table.rows, table);
      if (point) {
        splitPoints.push(point);
      }
    }
    if (xySeries.smVerticalAccessorValue && splitRowAccessor) {
      const accessor = (0, _utils.getAccessorByDimension)(splitRowAccessor, table.columns);
      const point = (0, _tooltip_actions.createSplitPoint)(accessor, xySeries.smVerticalAccessorValue, formattedDatatables[layer.layerId].table.rows, table);
      if (point) {
        splitPoints.push(point);
      }
    }
    const context = {
      data: [xSeriesPoint, ...splitPoints]
    };
    onClickValue(context);
  };
  const brushHandler = ({
    x
  }) => {
    var _table$columns$xAxisC, _table$columns$xAxisC2;
    if (!x) {
      return;
    }
    const [min, max] = x;
    if (!xAxisColumn || !isHistogramViz) {
      return;
    }
    const {
      table
    } = dataLayers[0];
    const xAccessor = dataLayers[0].xAccessor !== undefined ? (0, _utils.getAccessorByDimension)(dataLayers[0].xAccessor, table.columns) : undefined;
    const xAxisColumnIndex = table.columns.findIndex(el => el.id === xAccessor);
    const context = {
      range: [min, max],
      table,
      column: xAxisColumnIndex,
      ...(isEsqlMode ? {
        timeFieldName: (_table$columns$xAxisC = table.columns[xAxisColumnIndex].meta.sourceParams) === null || _table$columns$xAxisC === void 0 ? void 0 : (_table$columns$xAxisC2 = _table$columns$xAxisC.sourceField) === null || _table$columns$xAxisC2 === void 0 ? void 0 : _table$columns$xAxisC2.toString()
      } : {})
    };
    onSelectRange(context);
  };
  const legendInsideParams = {
    vAlign: (_legend$verticalAlign = legend.verticalAlignment) !== null && _legend$verticalAlign !== void 0 ? _legend$verticalAlign : _charts.VerticalAlignment.Top,
    hAlign: (_legend$horizontalAli = legend === null || legend === void 0 ? void 0 : legend.horizontalAlignment) !== null && _legend$horizontalAli !== void 0 ? _legend$horizontalAli : _charts.HorizontalAlignment.Right,
    direction: _charts.LayoutDirection.Vertical,
    floating: true,
    floatingColumns: (_legend$floatingColum = legend === null || legend === void 0 ? void 0 : legend.floatingColumns) !== null && _legend$floatingColum !== void 0 ? _legend$floatingColum : 1
  };
  const isHistogramModeEnabled = dataLayers.some(({
    isHistogram,
    seriesType,
    isStacked
  }) => isHistogram && (isStacked || seriesType !== _constants2.SeriesTypes.BAR || !chartHasMoreThanOneBarSeries));
  const isHorizontalTimeAxis = isTimeViz && isHistogramModeEnabled && !shouldRotate;
  const defaultXAxisPosition = shouldRotate ? _charts.Position.Left : _charts.Position.Bottom;
  const gridLineStyle = {
    visible: xAxisConfig === null || xAxisConfig === void 0 ? void 0 : xAxisConfig.showGridLines,
    strokeWidth: 1
  };
  const xAxisStyle = isHorizontalTimeAxis ? {
    tickLabel: {
      visible: Boolean(xAxisConfig === null || xAxisConfig === void 0 ? void 0 : xAxisConfig.showLabels),
      fill: xAxisConfig === null || xAxisConfig === void 0 ? void 0 : xAxisConfig.labelColor
    },
    tickLine: {
      visible: Boolean(xAxisConfig === null || xAxisConfig === void 0 ? void 0 : xAxisConfig.showLabels)
    },
    axisTitle: {
      visible: xAxisConfig === null || xAxisConfig === void 0 ? void 0 : xAxisConfig.showTitle
    }
  } : {
    tickLabel: {
      visible: xAxisConfig === null || xAxisConfig === void 0 ? void 0 : xAxisConfig.showLabels,
      rotation: xAxisConfig === null || xAxisConfig === void 0 ? void 0 : xAxisConfig.labelsOrientation,
      padding: linesPaddings.bottom != null ? {
        inner: linesPaddings.bottom
      } : undefined,
      fill: xAxisConfig === null || xAxisConfig === void 0 ? void 0 : xAxisConfig.labelColor
    },
    axisTitle: {
      visible: xAxisConfig === null || xAxisConfig === void 0 ? void 0 : xAxisConfig.showTitle,
      padding: !(xAxisConfig !== null && xAxisConfig !== void 0 && xAxisConfig.showLabels) && linesPaddings.bottom != null ? {
        inner: linesPaddings.bottom
      } : undefined
    }
  };
  const isSplitChart = splitColumnAccessor || splitRowAccessor;
  const splitTable = isSplitChart ? dataLayers[0].table : undefined;
  const splitColumnId = splitColumnAccessor && splitTable ? (0, _utils.getAccessorByDimension)(splitColumnAccessor, splitTable === null || splitTable === void 0 ? void 0 : splitTable.columns) : undefined;
  const splitRowId = splitRowAccessor && splitTable ? (0, _utils.getAccessorByDimension)(splitRowAccessor, splitTable === null || splitTable === void 0 ? void 0 : splitTable.columns) : undefined;
  const chartContainerStyle = (0, _react2.css)({
    width: '100%',
    height: '100%',
    overflowX: 'hidden',
    position: uiState ? 'absolute' : 'relative'
  });
  const {
    theme: settingsThemeOverrides = {},
    ...settingsOverrides
  } = (0, _chartExpressionsCommon.getOverridesFor)(overrides, 'settings');
  const referenceLinesFormatters = (0, _reference_lines.getReferenceLinesFormattersMap)(referenceLineLayers, formatFactory);

  // ES|QL charts are allowed to create filters only when the unified search bar query is ES|QL (e.g. in Discover)
  const applicationQuery = data.query.queryString.getQuery();
  const canCreateFilters = !isEsqlMode || isEsqlMode && applicationQuery && (0, _esQuery.isOfAggregateQueryType)(applicationQuery);
  // ES|QL charts are allowed to create alert rules only in dashboards
  const canCreateAlerts = isEsqlMode && applicationQuery && !(0, _esQuery.isOfAggregateQueryType)(applicationQuery);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_xy_chart.GlobalXYChartStyles, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 768,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement("div", {
    css: chartContainerStyle,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 769,
      columnNumber: 7
    }
  }, showLegend !== undefined && uiState && /*#__PURE__*/_react.default.createElement(_public.LegendToggle, {
    onClick: toggleLegend,
    showLegend: showLegend,
    legendPosition: legend.position,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 771,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_legend_color_picker.LegendColorPickerWrapperContext.Provider, {
    value: {
      uiState,
      setColor,
      legendPosition: legend.position,
      dataLayers,
      formattedDatatables,
      titles,
      fieldFormats,
      singleTable
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 777,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Chart, (0, _extends2.default)({
    ref: chartRef
  }, (0, _chartExpressionsCommon.getOverridesFor)(overrides, 'chart'), {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 789,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Tooltip, {
    boundary: appFixedViewport,
    headerFormatter: !args.detailedTooltip && xAxisColumn ? ({
      value
    }) => /*#__PURE__*/_react.default.createElement(_tooltip.TooltipHeader, {
      value: value,
      formatter: safeXAccessorLabelRenderer,
      xDomain: rawXDomain,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 795,
        columnNumber: 23
      }
    }) : undefined,
    actions: (0, _tooltip_actions.getTooltipActions)(dataLayers, onClickMultiValue, onCreateAlertRule, fieldFormats, formattedDatatables, xAxisFormatter, formatFactory, isEsqlMode, canCreateAlerts, interactive && !args.detailedTooltip),
    customTooltip: args.detailedTooltip ? ({
      header,
      values
    }) => /*#__PURE__*/_react.default.createElement(_tooltip.Tooltip, {
      header: header,
      values: values,
      titles: titles,
      fieldFormats: fieldFormats,
      formatFactory: formatFactory,
      formattedDatatables: formattedDatatables,
      splitAccessors: {
        splitColumnAccessor: splitColumnId,
        splitRowAccessor: splitRowId
      },
      layers: dataLayers,
      xDomain: isTimeViz ? rawXDomain : undefined,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 818,
        columnNumber: 23
      }
    }) : undefined,
    type: args.showTooltip ? _charts.TooltipType.VerticalCursor : _charts.TooltipType.None,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 790,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Settings, (0, _extends2.default)({
    noResults: /*#__PURE__*/_react.default.createElement(_public.EmptyPlaceholder, {
      icon: icon,
      renderComplete: onRenderChange,
      css: xyChartEmptyStyles,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 839,
        columnNumber: 17
      }
    }),
    onRenderChange: onRenderChange,
    pointerUpdateDebounce: 0 // use the `handleCursorUpdate` debounce time
    ,
    onPointerUpdate: syncCursor ? handleCursorUpdate : undefined,
    externalPointerEvents: {
      tooltip: {
        visible: syncTooltips,
        placement: _charts.Placement.Right
      }
    },
    legendColorPicker: uiState ? _legend_color_picker.LegendColorPickerWrapper : undefined,
    debugState: (_window$_echDebugStat = window._echDebugStateFlag) !== null && _window$_echDebugStat !== void 0 ? _window$_echDebugStat : false,
    showLegend: showLegend,
    legendPosition: legend !== null && legend !== void 0 && legend.isInside ? legendInsideParams : legend.position,
    legendSize: _constants.LegendSizeToPixels[(_legend$legendSize = legend.legendSize) !== null && _legend$legendSize !== void 0 ? _legend$legendSize : _constants.DEFAULT_LEGEND_SIZE],
    legendValues: isHistogramViz ? legend.legendStats : [],
    legendTitle: getLegendTitle(legend.title, dataLayers[0], legend.isTitleVisible),
    theme: [{
      barSeriesStyle: {
        ...valueLabelsStyling
      },
      background: {
        color: undefined // removes background for embeddables
      },
      legend: {
        labelOptions: {
          maxLines: legend.shouldTruncate ? (_legend$maxLines = legend === null || legend === void 0 ? void 0 : legend.maxLines) !== null && _legend$maxLines !== void 0 ? _legend$maxLines : 1 : 0
        }
      },
      // if not title or labels are shown for axes, add some padding if required by reference line markers
      chartMargins: {
        // Temporary margin defaults
        ..._charts.LEGACY_LIGHT_THEME.chartMargins,
        ...(0, _reference_lines.computeChartMargins)(linesPaddings, {
          ...tickLabelsVisibilitySettings,
          x: xAxisConfig === null || xAxisConfig === void 0 ? void 0 : xAxisConfig.showLabels
        }, {
          ...axisTitlesVisibilitySettings,
          x: xAxisConfig === null || xAxisConfig === void 0 ? void 0 : xAxisConfig.showTitle
        }, yAxesMap, shouldRotate)
      },
      markSizeRatio: args.markSizeRatio
    }, ...(Array.isArray(settingsThemeOverrides) ? settingsThemeOverrides : [settingsThemeOverrides])],
    baseTheme: chartBaseTheme,
    allowBrushingLastHistogramBin: isTimeViz,
    rotation: shouldRotate ? 90 : 0,
    xDomain: xDomain
    // enable brushing only for time charts, for both ES|QL and DSL queries
    ,
    onBrushEnd: interactive ? brushHandler : undefined,
    onElementClick: interactive ? clickHandler : undefined,
    legendAction: interactive && canCreateFilters ? (0, _legend_action.getLegendAction)(dataLayers, onClickValue, layerCellValueActions, fieldFormats, formattedDatatables, titles, singleTable) : undefined,
    ariaLabel: args.ariaLabel,
    ariaUseDefaultSummary: !args.ariaLabel,
    orderOrdinalBinsBy: args.orderBucketsBySum ? {
      direction: _charts.Direction.Descending
    } : undefined,
    locale: _i18n.i18n.getLocale()
  }, settingsOverrides, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 837,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_xy_current_time.XYCurrentTime, {
    enabled: Boolean(args.addTimeMarker && isTimeViz),
    isDarkMode: darkMode,
    domain: rawXDomain,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 919,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, (0, _extends2.default)({
    id: "x",
    position: xAxisConfig !== null && xAxisConfig !== void 0 && xAxisConfig.position ? (0, _helpers2.getOriginalAxisPosition)(xAxisConfig === null || xAxisConfig === void 0 ? void 0 : xAxisConfig.position, shouldRotate) : defaultXAxisPosition,
    title: xTitle,
    gridLine: gridLineStyle,
    hide: (xAxisConfig === null || xAxisConfig === void 0 ? void 0 : xAxisConfig.hide) || ((_dataLayers$3 = dataLayers[0]) === null || _dataLayers$3 === void 0 ? void 0 : _dataLayers$3.simpleView) || !((_dataLayers$4 = dataLayers[0]) !== null && _dataLayers$4 !== void 0 && _dataLayers$4.xAccessor),
    tickFormat: d => {
      let value = safeXAccessorLabelRenderer(d) || '';
      if (xAxisConfig !== null && xAxisConfig !== void 0 && xAxisConfig.truncate && value.length > xAxisConfig.truncate) {
        value = `${value.slice(0, xAxisConfig.truncate)}...`;
      }
      return value;
    },
    style: xAxisStyle,
    showOverlappingLabels: xAxisConfig === null || xAxisConfig === void 0 ? void 0 : xAxisConfig.showOverlappingLabels,
    showDuplicatedTicks: xAxisConfig === null || xAxisConfig === void 0 ? void 0 : xAxisConfig.showDuplicates
  }, (0, _chartExpressionsCommon.getOverridesFor)(overrides, 'axisX'), {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 925,
      columnNumber: 13
    }
  })), isSplitChart && splitTable && /*#__PURE__*/_react.default.createElement(_split_chart.SplitChart, {
    splitColumnAccessor: splitColumnAccessor,
    splitRowAccessor: splitRowAccessor,
    columns: splitTable.columns,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 948,
      columnNumber: 15
    }
  }), yAxesConfiguration.map(axis => {
    var _dataLayers$5;
    return /*#__PURE__*/_react.default.createElement(_charts.Axis, (0, _extends2.default)({
      key: axis.groupId,
      id: axis.groupId,
      groupId: axis.groupId,
      position: axis.position,
      title: axis.title || getYAxesTitles(axis.series),
      gridLine: {
        visible: axis.showGridLines
      },
      hide: axis.hide || ((_dataLayers$5 = dataLayers[0]) === null || _dataLayers$5 === void 0 ? void 0 : _dataLayers$5.simpleView),
      tickFormat: d => {
        var _axis$formatter;
        let value = ((_axis$formatter = axis.formatter) === null || _axis$formatter === void 0 ? void 0 : _axis$formatter.convert(d)) || '';
        if (axis.truncate && value.length > axis.truncate) {
          value = `${value.slice(0, axis.truncate)}...`;
        }
        return value;
      },
      style: getYAxesStyle(axis),
      domain: getYAxisDomain(axis),
      showOverlappingLabels: axis.showOverlappingLabels,
      showDuplicatedTicks: axis.showDuplicates
    }, (0, _chartExpressionsCommon.getOverridesFor)(overrides, /left/i.test(axis.groupId) ? 'axisLeft' : 'axisRight'), {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 956,
        columnNumber: 17
      }
    }));
  }), !hideEndzones && /*#__PURE__*/_react.default.createElement(_x_domain.XyEndzones, {
    baseDomain: rawXDomain,
    extendedDomain: xDomain,
    darkMode: darkMode,
    histogramMode: dataLayers.every(layer => layer.isHistogram && (layer.isStacked || !layer.splitAccessors || !layer.splitAccessors.length) && (layer.isStacked || layer.seriesType !== _constants2.SeriesTypes.BAR || !chartHasMoreThanOneBarSeries)),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 986,
      columnNumber: 15
    }
  }), dataLayers.length && /*#__PURE__*/_react.default.createElement(_data_layers.DataLayers, {
    titles: titles,
    layers: dataLayers,
    endValue: endValue,
    timeZone: timeZone,
    syncColors: syncColors,
    valueLabels: valueLabels,
    fillOpacity: args.fillOpacity,
    minBarHeight: args.minBarHeight,
    formatFactory: formatFactory,
    paletteService: paletteService,
    palettes: palettes,
    fittingFunction: fittingFunction,
    emphasizeFitting: emphasizeFitting,
    yAxesConfiguration: yAxesConfiguration,
    xAxisConfiguration: xAxisConfig ? axesConfiguration[axesConfiguration.length - 1] : undefined,
    shouldShowValueLabels: shouldShowValueLabels,
    formattedDatatables: formattedDatatables,
    chartHasMoreThanOneBarSeries: chartHasMoreThanOneBarSeries,
    defaultXScaleType: defaultXScaleType,
    fieldFormats: fieldFormats,
    uiState: uiState,
    singleTable: singleTable,
    isDarkMode: darkMode,
    pointVisibility: pointVisibility,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 1002,
      columnNumber: 15
    }
  }), referenceLineLayers.length ? /*#__PURE__*/_react.default.createElement(_reference_lines.ReferenceLines, {
    layers: referenceLineLayers,
    xAxisFormatter: xAxisFormatter,
    axesConfiguration: axesConfiguration,
    isHorizontal: shouldRotate,
    paddingMap: linesPaddings,
    titles: titles,
    yAxesMap: yAxesMap,
    formatters: referenceLinesFormatters,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 1032,
      columnNumber: 15
    }
  }) : null, (rangeAnnotations.length || lineAnnotations.length) && isTimeViz ? /*#__PURE__*/_react.default.createElement(_annotations.Annotations, {
    rangeAnnotations: rangeAnnotations,
    groupedLineAnnotations: groupedLineAnnotations,
    timeFormat: timeFormat,
    isHorizontal: shouldRotate,
    paddingMap: linesPaddings,
    isBarChart: filteredBarLayers.length > 0,
    minInterval: minInterval,
    simpleView: shouldHideDetails,
    outsideDimension: rangeAnnotations.length && shouldHideDetails ? _annotations.OUTSIDE_RECT_ANNOTATION_WIDTH_SUGGESTION : isHorizontalTimeAxis ? MULTILAYER_TIME_AXIS_TICKLINE_PADDING + chartBaseTheme.axes.tickLabel.fontSize : Math.max(chartBaseTheme.axes.tickLine.size, _annotations.OUTSIDE_RECT_ANNOTATION_WIDTH),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 1044,
      columnNumber: 15
    }
  }) : null))));
}
const defaultLegendTitle = _i18n.i18n.translate('expressionXY.xyChart.legendTitle', {
  defaultMessage: 'Legend'
});
function getLegendTitle(title, layer, isTitleVisible) {
  var _layer$splitAccessors, _getColumnByAccessor, _layer$splitAccessors2;
  if (!isTitleVisible) {
    return undefined;
  }
  if (typeof title === 'string' && title.length > 0) {
    return title;
  }
  return layer !== null && layer !== void 0 && (_layer$splitAccessors = layer.splitAccessors) !== null && _layer$splitAccessors !== void 0 && _layer$splitAccessors[0] ? (_getColumnByAccessor = (0, _utils.getColumnByAccessor)((_layer$splitAccessors2 = layer.splitAccessors) === null || _layer$splitAccessors2 === void 0 ? void 0 : _layer$splitAccessors2[0], layer === null || layer === void 0 ? void 0 : layer.table.columns)) === null || _getColumnByAccessor === void 0 ? void 0 : _getColumnByAccessor.name : defaultLegendTitle;
}
const xyChartEmptyStyles = (0, _react2.css)({
  height: '100%',
  display: 'flex',
  flexDirection: 'column',
  alignItems: 'center',
  justifyContent: 'center'
});